/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import java.io.IOException;
import java.util.Map;

public final class KeyItem
implements JsonSerializable<KeyItem> {
    private String kid;
    private KeyAttributes attributes;
    private Map<String, String> tags;
    private Boolean managed;

    private KeyItem() {
    }

    public String getKid() {
        return this.kid;
    }

    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KeyItem fromJson(JsonReader jsonReader) throws IOException {
        return (KeyItem)jsonReader.readObject(reader -> {
            KeyItem deserializedKeyItem = new KeyItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedKeyItem.kid = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedKeyItem.attributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedKeyItem.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyItem;
        });
    }
}

