/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CognitiveServicesAccount;
import java.io.IOException;

public final class CognitiveServicesAccountKey
extends CognitiveServicesAccount {
    private String odataType = "#Microsoft.Azure.Search.CognitiveServicesByKey";
    private String key;

    public CognitiveServicesAccountKey(String key) {
        this.key = key;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public CognitiveServicesAccountKey setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static CognitiveServicesAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return (CognitiveServicesAccountKey)jsonReader.readObject(reader -> {
            String description = null;
            boolean keyFound = false;
            String key = null;
            String odataType = "#Microsoft.Azure.Search.CognitiveServicesByKey";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound) {
                CognitiveServicesAccountKey deserializedCognitiveServicesAccountKey = new CognitiveServicesAccountKey(key);
                deserializedCognitiveServicesAccountKey.setDescription(description);
                deserializedCognitiveServicesAccountKey.odataType = odataType;
                return deserializedCognitiveServicesAccountKey;
            }
            throw new IllegalStateException("Missing required property: key");
        });
    }

    public CognitiveServicesAccountKey setKey(String key) {
        this.key = key;
        return this;
    }
}

