/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;

public final class LuceneStandardTokenizerV1
extends LexicalTokenizer {
    private String odataType = "#Microsoft.Azure.Search.StandardTokenizer";
    private Integer maxTokenLength;

    public LuceneStandardTokenizerV1(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public LuceneStandardTokenizerV1 setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        return jsonWriter.writeEndObject();
    }

    public static LuceneStandardTokenizerV1 fromJson(JsonReader jsonReader) throws IOException {
        return (LuceneStandardTokenizerV1)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.StandardTokenizer";
            Integer maxTokenLength = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LuceneStandardTokenizerV1 deserializedLuceneStandardTokenizerV1 = new LuceneStandardTokenizerV1(name);
                deserializedLuceneStandardTokenizerV1.odataType = odataType;
                deserializedLuceneStandardTokenizerV1.maxTokenLength = maxTokenLength;
                return deserializedLuceneStandardTokenizerV1;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

