/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.batching;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public final class SearchBatchingUtils {
    private static final double JITTER_FACTOR = 0.05;
    static final String BATCH_SIZE_SCALED_DOWN = "Scaling down batch size due to 413 (Payload too large) response.{}Scaled down from {} to {}";

    static boolean batchAvailableForProcessing(int actionCount, int inflightActionCount, int batchActionCount) {
        return actionCount + inflightActionCount >= batchActionCount;
    }

    static boolean isSuccess(int statusCode) {
        return statusCode == 200 || statusCode == 201;
    }

    static boolean isRetryable(int statusCode) {
        return statusCode == 409 || statusCode == 422 || statusCode == 503;
    }

    static Duration calculateRetryDelay(int backoffCount, long delayNanos, long maxDelayNanos) {
        long delayWithJitterInNanos = ThreadLocalRandom.current().nextLong((long)((double)delayNanos * 0.95), (long)((double)delayNanos * 1.05));
        return Duration.ofNanos(Math.min((1L << backoffCount) * delayWithJitterInNanos, maxDelayNanos));
    }

    static RuntimeException createDocumentTooLargeException() {
        return new RuntimeException("Document is too large to be indexed and won't be tried again.");
    }

    static RuntimeException createDocumentHitRetryLimitException() {
        return new RuntimeException("Document has reached retry limit and won't be tried again.");
    }
}

