/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreProjectionSelector;
import java.io.IOException;
import java.util.List;

public final class SearchIndexerKnowledgeStoreTableProjectionSelector
extends SearchIndexerKnowledgeStoreProjectionSelector {
    private final String tableName;

    public SearchIndexerKnowledgeStoreTableProjectionSelector(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setReferenceKeyName(String referenceKeyName) {
        super.setReferenceKeyName(referenceKeyName);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setGeneratedKeyName(String generatedKeyName) {
        super.setGeneratedKeyName(generatedKeyName);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setSource(String source) {
        super.setSource(source);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setSourceContext(String sourceContext) {
        super.setSourceContext(sourceContext);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setInputs(List<InputFieldMappingEntry> inputs) {
        super.setInputs(inputs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("referenceKeyName", this.getReferenceKeyName());
        jsonWriter.writeStringField("generatedKeyName", this.getGeneratedKeyName());
        jsonWriter.writeStringField("source", this.getSource());
        jsonWriter.writeStringField("sourceContext", this.getSourceContext());
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("tableName", this.tableName);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerKnowledgeStoreTableProjectionSelector fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerKnowledgeStoreTableProjectionSelector)jsonReader.readObject(reader -> {
            String referenceKeyName = null;
            String generatedKeyName = null;
            String source = null;
            String sourceContext = null;
            List inputs = null;
            boolean tableNameFound = false;
            String tableName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("referenceKeyName".equals(fieldName)) {
                    referenceKeyName = reader.getString();
                    continue;
                }
                if ("generatedKeyName".equals(fieldName)) {
                    generatedKeyName = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    source = reader.getString();
                    continue;
                }
                if ("sourceContext".equals(fieldName)) {
                    sourceContext = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    tableName = reader.getString();
                    tableNameFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (tableNameFound) {
                SearchIndexerKnowledgeStoreTableProjectionSelector deserializedSearchIndexerKnowledgeStoreTableProjectionSelector = new SearchIndexerKnowledgeStoreTableProjectionSelector(tableName);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setReferenceKeyName(referenceKeyName);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setGeneratedKeyName(generatedKeyName);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setSource(source);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setSourceContext(sourceContext);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setInputs(inputs);
                return deserializedSearchIndexerKnowledgeStoreTableProjectionSelector;
            }
            throw new IllegalStateException("Missing required property: tableName");
        });
    }
}

