/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerIndexProjectionSelector;
import com.azure.search.documents.indexes.models.SearchIndexerIndexProjectionsParameters;
import java.io.IOException;
import java.util.List;

public final class SearchIndexerIndexProjection
implements JsonSerializable<SearchIndexerIndexProjection> {
    private final List<SearchIndexerIndexProjectionSelector> selectors;
    private SearchIndexerIndexProjectionsParameters parameters;

    public SearchIndexerIndexProjection(List<SearchIndexerIndexProjectionSelector> selectors) {
        this.selectors = selectors;
    }

    public List<SearchIndexerIndexProjectionSelector> getSelectors() {
        return this.selectors;
    }

    public SearchIndexerIndexProjectionsParameters getParameters() {
        return this.parameters;
    }

    public SearchIndexerIndexProjection setParameters(SearchIndexerIndexProjectionsParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("selectors", this.selectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerIndexProjection fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerIndexProjection)jsonReader.readObject(reader -> {
            boolean selectorsFound = false;
            List selectors = null;
            SearchIndexerIndexProjectionsParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("selectors".equals(fieldName)) {
                    selectors = reader.readArray(reader1 -> SearchIndexerIndexProjectionSelector.fromJson(reader1));
                    selectorsFound = true;
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = SearchIndexerIndexProjectionsParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (selectorsFound) {
                SearchIndexerIndexProjection deserializedSearchIndexerIndexProjection = new SearchIndexerIndexProjection(selectors);
                deserializedSearchIndexerIndexProjection.parameters = parameters;
                return deserializedSearchIndexerIndexProjection;
            }
            throw new IllegalStateException("Missing required property: selectors");
        });
    }
}

