/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV2;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV2;
import com.azure.search.documents.indexes.models.ClassicTokenizer;
import com.azure.search.documents.indexes.models.EdgeNGramTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftLanguageStemmingTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftLanguageTokenizer;
import com.azure.search.documents.indexes.models.NGramTokenizer;
import com.azure.search.documents.indexes.models.PathHierarchyTokenizer;
import com.azure.search.documents.indexes.models.PatternTokenizer;
import com.azure.search.documents.indexes.models.UaxUrlEmailTokenizer;
import java.io.IOException;

public class LexicalTokenizer
implements JsonSerializable<LexicalTokenizer> {
    private String odataType = "LexicalTokenizer";
    private final String name;

    public LexicalTokenizer(String name) {
        this.name = name;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static LexicalTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (LexicalTokenizer)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                LexicalTokenizer lexicalTokenizer;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.ClassicTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = ClassicTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.EdgeNGramTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = EdgeNGramTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.KeywordTokenizerV2".equals(discriminatorValue)) {
                    lexicalTokenizer = KeywordTokenizerV2.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.MicrosoftLanguageTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = MicrosoftLanguageTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = MicrosoftLanguageStemmingTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.NGramTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = NGramTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.PatternTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = PatternTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.StandardTokenizerV2".equals(discriminatorValue)) {
                    lexicalTokenizer = LuceneStandardTokenizerV2.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.UaxUrlEmailTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = UaxUrlEmailTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.PathHierarchyTokenizerV2".equals(discriminatorValue)) {
                    lexicalTokenizer = PathHierarchyTokenizer.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.StandardTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = LuceneStandardTokenizerV1.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                if ("#Microsoft.Azure.Search.KeywordTokenizer".equals(discriminatorValue)) {
                    lexicalTokenizer = KeywordTokenizerV1.fromJson(readerToUse.reset());
                    return lexicalTokenizer;
                }
                lexicalTokenizer = LexicalTokenizer.fromJsonKnownDiscriminator(readerToUse.reset());
                return lexicalTokenizer;
            }
        });
    }

    static LexicalTokenizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (LexicalTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LexicalTokenizer deserializedLexicalTokenizer = new LexicalTokenizer(name);
                deserializedLexicalTokenizer.odataType = odataType;
                return deserializedLexicalTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

