/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ExhaustiveKnnParameters;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmKind;
import java.io.IOException;

public final class ExhaustiveKnnAlgorithmConfiguration
extends VectorSearchAlgorithmConfiguration {
    private VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.EXHAUSTIVE_KNN;
    private ExhaustiveKnnParameters parameters;

    public ExhaustiveKnnAlgorithmConfiguration(String name) {
        super(name);
    }

    @Override
    public VectorSearchAlgorithmKind getKind() {
        return this.kind;
    }

    public ExhaustiveKnnParameters getParameters() {
        return this.parameters;
    }

    public ExhaustiveKnnAlgorithmConfiguration setParameters(ExhaustiveKnnParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("exhaustiveKnnParameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ExhaustiveKnnAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ExhaustiveKnnAlgorithmConfiguration)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.EXHAUSTIVE_KNN;
            ExhaustiveKnnParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchAlgorithmKind.fromString(reader.getString());
                    continue;
                }
                if ("exhaustiveKnnParameters".equals(fieldName)) {
                    parameters = ExhaustiveKnnParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                ExhaustiveKnnAlgorithmConfiguration deserializedExhaustiveKnnAlgorithmConfiguration = new ExhaustiveKnnAlgorithmConfiguration(name);
                deserializedExhaustiveKnnAlgorithmConfiguration.kind = kind;
                deserializedExhaustiveKnnAlgorithmConfiguration.parameters = parameters;
                return deserializedExhaustiveKnnAlgorithmConfiguration;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

