/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.MappingCharFilter;
import com.azure.search.documents.indexes.models.PatternReplaceCharFilter;
import java.io.IOException;

public class CharFilter
implements JsonSerializable<CharFilter> {
    private String odataType = "CharFilter";
    private final String name;

    public CharFilter(String name) {
        this.name = name;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static CharFilter fromJson(JsonReader jsonReader) throws IOException {
        return (CharFilter)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CharFilter charFilter;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.MappingCharFilter".equals(discriminatorValue)) {
                    charFilter = MappingCharFilter.fromJson(readerToUse.reset());
                    return charFilter;
                }
                if ("#Microsoft.Azure.Search.PatternReplaceCharFilter".equals(discriminatorValue)) {
                    charFilter = PatternReplaceCharFilter.fromJson(readerToUse.reset());
                    return charFilter;
                }
                charFilter = CharFilter.fromJsonKnownDiscriminator(readerToUse.reset());
                return charFilter;
            }
        });
    }

    static CharFilter fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (CharFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                CharFilter deserializedCharFilter = new CharFilter(name);
                deserializedCharFilter.odataType = odataType;
                return deserializedCharFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

