/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureOpenAIModelName;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;

public class AzureOpenAIVectorizerParameters
implements JsonSerializable<AzureOpenAIVectorizerParameters> {
    private String resourceUrl;
    private String deploymentName;
    private String apiKey;
    private SearchIndexerDataIdentity authIdentity;
    private AzureOpenAIModelName modelName;

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public AzureOpenAIVectorizerParameters setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public AzureOpenAIVectorizerParameters setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public AzureOpenAIVectorizerParameters setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    public AzureOpenAIVectorizerParameters setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    public AzureOpenAIModelName getModelName() {
        return this.modelName;
    }

    public AzureOpenAIVectorizerParameters setModelName(AzureOpenAIModelName modelName) {
        this.modelName = modelName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceUri", this.resourceUrl);
        jsonWriter.writeStringField("deploymentId", this.deploymentName);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("authIdentity", (JsonSerializable)this.authIdentity);
        jsonWriter.writeStringField("modelName", this.modelName == null ? null : this.modelName.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureOpenAIVectorizerParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureOpenAIVectorizerParameters)jsonReader.readObject(reader -> {
            AzureOpenAIVectorizerParameters deserializedAzureOpenAIVectorizerParameters = new AzureOpenAIVectorizerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceUri".equals(fieldName)) {
                    deserializedAzureOpenAIVectorizerParameters.resourceUrl = reader.getString();
                    continue;
                }
                if ("deploymentId".equals(fieldName)) {
                    deserializedAzureOpenAIVectorizerParameters.deploymentName = reader.getString();
                    continue;
                }
                if ("apiKey".equals(fieldName)) {
                    deserializedAzureOpenAIVectorizerParameters.apiKey = reader.getString();
                    continue;
                }
                if ("authIdentity".equals(fieldName)) {
                    deserializedAzureOpenAIVectorizerParameters.authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    deserializedAzureOpenAIVectorizerParameters.modelName = AzureOpenAIModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureOpenAIVectorizerParameters;
        });
    }
}

