/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.EdgeNGramTokenFilterSide;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class EdgeNGramTokenFilterV2
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2";
    private Integer minGram;
    private Integer maxGram;
    private EdgeNGramTokenFilterSide side;

    public EdgeNGramTokenFilterV2(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMinGram() {
        return this.minGram;
    }

    public EdgeNGramTokenFilterV2 setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    public Integer getMaxGram() {
        return this.maxGram;
    }

    public EdgeNGramTokenFilterV2 setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    public EdgeNGramTokenFilterSide getSide() {
        return this.side;
    }

    public EdgeNGramTokenFilterV2 setSide(EdgeNGramTokenFilterSide side) {
        this.side = side;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minGram", (Number)this.minGram);
        jsonWriter.writeNumberField("maxGram", (Number)this.maxGram);
        jsonWriter.writeStringField("side", this.side == null ? null : this.side.toString());
        return jsonWriter.writeEndObject();
    }

    public static EdgeNGramTokenFilterV2 fromJson(JsonReader jsonReader) throws IOException {
        return (EdgeNGramTokenFilterV2)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2";
            Integer minGram = null;
            Integer maxGram = null;
            EdgeNGramTokenFilterSide side = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("minGram".equals(fieldName)) {
                    minGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxGram".equals(fieldName)) {
                    maxGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("side".equals(fieldName)) {
                    side = EdgeNGramTokenFilterSide.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                EdgeNGramTokenFilterV2 deserializedEdgeNGramTokenFilterV2 = new EdgeNGramTokenFilterV2(name);
                deserializedEdgeNGramTokenFilterV2.odataType = odataType;
                deserializedEdgeNGramTokenFilterV2.minGram = minGram;
                deserializedEdgeNGramTokenFilterV2.maxGram = maxGram;
                deserializedEdgeNGramTokenFilterV2.side = side;
                return deserializedEdgeNGramTokenFilterV2;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

