/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.SplitSkillLanguage;
import com.azure.search.documents.indexes.models.TextSplitMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SplitSkill
extends SearchIndexerSkill {
    private SplitSkillLanguage defaultLanguageCode;
    private TextSplitMode textSplitMode;
    private Integer maximumPageLength;

    public SplitSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public SplitSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public SplitSkill setDefaultLanguageCode(SplitSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public TextSplitMode getTextSplitMode() {
        return this.textSplitMode;
    }

    public SplitSkill setTextSplitMode(TextSplitMode textSplitMode) {
        this.textSplitMode = textSplitMode;
        return this;
    }

    public Integer getMaximumPageLength() {
        return this.maximumPageLength;
    }

    public SplitSkill setMaximumPageLength(Integer maximumPageLength) {
        this.maximumPageLength = maximumPageLength;
        return this;
    }

    @Override
    public SplitSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SplitSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SplitSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.SplitSkill");
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultLanguageCode", Objects.toString((Object)this.defaultLanguageCode, null));
        jsonWriter.writeStringField("textSplitMode", Objects.toString((Object)this.textSplitMode, null));
        jsonWriter.writeNumberField("maximumPageLength", (Number)this.maximumPageLength);
        return jsonWriter.writeEndObject();
    }

    public static SplitSkill fromJson(JsonReader jsonReader) throws IOException {
        return (SplitSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            SplitSkillLanguage defaultLanguageCode = null;
            TextSplitMode textSplitMode = null;
            Integer maximumPageLength = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Skills.Text.SplitSkill".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.SplitSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = SplitSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("textSplitMode".equals(fieldName)) {
                    textSplitMode = TextSplitMode.fromString(reader.getString());
                    continue;
                }
                if ("maximumPageLength".equals(fieldName)) {
                    maximumPageLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                SplitSkill deserializedSplitSkill = new SplitSkill(inputs, outputs);
                deserializedSplitSkill.setName(name);
                deserializedSplitSkill.setDescription(description);
                deserializedSplitSkill.setContext(context);
                deserializedSplitSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedSplitSkill.textSplitMode = textSplitMode;
                deserializedSplitSkill.maximumPageLength = maximumPageLength;
                return deserializedSplitSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

