/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Objects;

public final class IndexingSchedule
implements JsonSerializable<IndexingSchedule> {
    private final Duration interval;
    private OffsetDateTime startTime;

    public IndexingSchedule(Duration interval) {
        this.interval = interval;
    }

    public Duration getInterval() {
        return this.interval;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public IndexingSchedule setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("interval", Objects.toString(this.interval, null));
        jsonWriter.writeStringField("startTime", Objects.toString(this.startTime, null));
        return jsonWriter.writeEndObject();
    }

    public static IndexingSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (IndexingSchedule)jsonReader.readObject(reader -> {
            boolean intervalFound = false;
            Duration interval = null;
            OffsetDateTime startTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("interval".equals(fieldName)) {
                    interval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    intervalFound = true;
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (intervalFound) {
                IndexingSchedule deserializedIndexingSchedule = new IndexingSchedule(interval);
                deserializedIndexingSchedule.startTime = startTime;
                return deserializedIndexingSchedule;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!intervalFound) {
                missingProperties.add("interval");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

