/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CjkBigramTokenFilterScripts;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CjkBigramTokenFilter
extends TokenFilter {
    private List<CjkBigramTokenFilterScripts> ignoreScripts;
    private Boolean outputUnigrams;

    public CjkBigramTokenFilter(String name) {
        super(name);
    }

    public List<CjkBigramTokenFilterScripts> getIgnoreScripts() {
        return this.ignoreScripts;
    }

    public CjkBigramTokenFilter setIgnoreScripts(List<CjkBigramTokenFilterScripts> ignoreScripts) {
        this.ignoreScripts = ignoreScripts;
        return this;
    }

    public Boolean areOutputUnigrams() {
        return this.outputUnigrams;
    }

    public CjkBigramTokenFilter setOutputUnigrams(Boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.CjkBigramTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("ignoreScripts", this.ignoreScripts, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeBooleanField("outputUnigrams", this.outputUnigrams);
        return jsonWriter.writeEndObject();
    }

    public static CjkBigramTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (CjkBigramTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            List ignoreScripts = null;
            Boolean outputUnigrams = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.CjkBigramTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.CjkBigramTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("ignoreScripts".equals(fieldName)) {
                    ignoreScripts = reader.readArray(reader1 -> CjkBigramTokenFilterScripts.fromString(reader1.getString()));
                    continue;
                }
                if ("outputUnigrams".equals(fieldName)) {
                    outputUnigrams = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                CjkBigramTokenFilter deserializedCjkBigramTokenFilter = new CjkBigramTokenFilter(name);
                deserializedCjkBigramTokenFilter.ignoreScripts = ignoreScripts;
                deserializedCjkBigramTokenFilter.outputUnigrams = outputUnigrams;
                return deserializedCjkBigramTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public CjkBigramTokenFilter setIgnoreScripts(CjkBigramTokenFilterScripts ... ignoreScripts) {
        this.ignoreScripts = ignoreScripts == null ? null : Arrays.asList(ignoreScripts);
        return this;
    }
}

