/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ListSkillsetsResult
implements JsonSerializable<ListSkillsetsResult> {
    private final List<SearchIndexerSkillset> skillsets;

    public ListSkillsetsResult(List<SearchIndexerSkillset> skillsets) {
        this.skillsets = skillsets;
    }

    public List<SearchIndexerSkillset> getSkillsets() {
        return this.skillsets;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ListSkillsetsResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListSkillsetsResult)jsonReader.readObject(reader -> {
            boolean skillsetsFound = false;
            List skillsets = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    skillsets = reader.readArray(reader1 -> SearchIndexerSkillset.fromJson(reader1));
                    skillsetsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (skillsetsFound) {
                ListSkillsetsResult deserializedListSkillsetsResult = new ListSkillsetsResult(skillsets);
                return deserializedListSkillsetsResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!skillsetsFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

