/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.AutocompleteMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class AutocompleteRequest
implements JsonSerializable<AutocompleteRequest> {
    private final String searchText;
    private AutocompleteMode autocompleteMode;
    private String filter;
    private Boolean useFuzzyMatching;
    private String highlightPostTag;
    private String highlightPreTag;
    private Double minimumCoverage;
    private String searchFields;
    private final String suggesterName;
    private Integer top;

    public AutocompleteRequest(String searchText, String suggesterName) {
        this.searchText = searchText;
        this.suggesterName = suggesterName;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public AutocompleteMode getAutocompleteMode() {
        return this.autocompleteMode;
    }

    public AutocompleteRequest setAutocompleteMode(AutocompleteMode autocompleteMode) {
        this.autocompleteMode = autocompleteMode;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AutocompleteRequest setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public Boolean isUseFuzzyMatching() {
        return this.useFuzzyMatching;
    }

    public AutocompleteRequest setUseFuzzyMatching(Boolean useFuzzyMatching) {
        this.useFuzzyMatching = useFuzzyMatching;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public AutocompleteRequest setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public AutocompleteRequest setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public AutocompleteRequest setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    public String getSearchFields() {
        return this.searchFields;
    }

    public AutocompleteRequest setSearchFields(String searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public String getSuggesterName() {
        return this.suggesterName;
    }

    public Integer getTop() {
        return this.top;
    }

    public AutocompleteRequest setTop(Integer top) {
        this.top = top;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.searchText);
        jsonWriter.writeStringField("suggesterName", this.suggesterName);
        jsonWriter.writeStringField("autocompleteMode", Objects.toString((Object)this.autocompleteMode, null));
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeBooleanField("fuzzy", this.useFuzzyMatching);
        jsonWriter.writeStringField("highlightPostTag", this.highlightPostTag);
        jsonWriter.writeStringField("highlightPreTag", this.highlightPreTag);
        jsonWriter.writeNumberField("minimumCoverage", (Number)this.minimumCoverage);
        jsonWriter.writeStringField("searchFields", this.searchFields);
        jsonWriter.writeNumberField("top", (Number)this.top);
        return jsonWriter.writeEndObject();
    }

    public static AutocompleteRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AutocompleteRequest)jsonReader.readObject(reader -> {
            boolean searchTextFound = false;
            String searchText = null;
            boolean suggesterNameFound = false;
            String suggesterName = null;
            AutocompleteMode autocompleteMode = null;
            String filter = null;
            Boolean useFuzzyMatching = null;
            String highlightPostTag = null;
            String highlightPreTag = null;
            Double minimumCoverage = null;
            String searchFields = null;
            Integer top = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("search".equals(fieldName)) {
                    searchText = reader.getString();
                    searchTextFound = true;
                    continue;
                }
                if ("suggesterName".equals(fieldName)) {
                    suggesterName = reader.getString();
                    suggesterNameFound = true;
                    continue;
                }
                if ("autocompleteMode".equals(fieldName)) {
                    autocompleteMode = AutocompleteMode.fromString(reader.getString());
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    filter = reader.getString();
                    continue;
                }
                if ("fuzzy".equals(fieldName)) {
                    useFuzzyMatching = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("highlightPostTag".equals(fieldName)) {
                    highlightPostTag = reader.getString();
                    continue;
                }
                if ("highlightPreTag".equals(fieldName)) {
                    highlightPreTag = reader.getString();
                    continue;
                }
                if ("minimumCoverage".equals(fieldName)) {
                    minimumCoverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("searchFields".equals(fieldName)) {
                    searchFields = reader.getString();
                    continue;
                }
                if ("top".equals(fieldName)) {
                    top = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (searchTextFound && suggesterNameFound) {
                AutocompleteRequest deserializedAutocompleteRequest = new AutocompleteRequest(searchText, suggesterName);
                deserializedAutocompleteRequest.autocompleteMode = autocompleteMode;
                deserializedAutocompleteRequest.filter = filter;
                deserializedAutocompleteRequest.useFuzzyMatching = useFuzzyMatching;
                deserializedAutocompleteRequest.highlightPostTag = highlightPostTag;
                deserializedAutocompleteRequest.highlightPreTag = highlightPreTag;
                deserializedAutocompleteRequest.minimumCoverage = minimumCoverage;
                deserializedAutocompleteRequest.searchFields = searchFields;
                deserializedAutocompleteRequest.top = top;
                return deserializedAutocompleteRequest;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!searchTextFound) {
                missingProperties.add("search");
            }
            if (!suggesterNameFound) {
                missingProperties.add("suggesterName");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

