// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

/** A builder for creating a new instance of the ServiceBusManagementClient type. */
@ServiceClientBuilder(serviceClients = {ServiceBusManagementClientImpl.class})
public final class ServiceBusManagementClientImplBuilder {
    /*
     * The Service Bus fully qualified domain name.
     */
    private String endpoint;

    /**
     * Sets The Service Bus fully qualified domain name.
     *
     * @param endpoint the endpoint value.
     * @return the ServiceBusManagementClientImplBuilder.
     */
    public ServiceBusManagementClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /*
     * Api Version
     */
    private String apiVersion;

    /**
     * Sets Api Version.
     *
     * @param apiVersion the apiVersion value.
     * @return the ServiceBusManagementClientImplBuilder.
     */
    public ServiceBusManagementClientImplBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    /*
     * The HTTP pipeline to send requests through
     */
    private HttpPipeline pipeline;

    /**
     * Sets The HTTP pipeline to send requests through.
     *
     * @param pipeline the pipeline value.
     * @return the ServiceBusManagementClientImplBuilder.
     */
    public ServiceBusManagementClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    /*
     * The serializer to serialize an object into a string
     */
    private SerializerAdapter serializerAdapter;

    /**
     * Sets The serializer to serialize an object into a string.
     *
     * @param serializerAdapter the serializerAdapter value.
     * @return the ServiceBusManagementClientImplBuilder.
     */
    public ServiceBusManagementClientImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    /**
     * Builds an instance of ServiceBusManagementClientImpl with the provided parameters.
     *
     * @return an instance of ServiceBusManagementClientImpl.
     */
    public ServiceBusManagementClientImpl buildClient() {
        if (pipeline == null) {
            this.pipeline =
                    new HttpPipelineBuilder()
                            .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                            .build();
        }
        if (serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        ServiceBusManagementClientImpl client =
                new ServiceBusManagementClientImpl(pipeline, serializerAdapter, endpoint, apiVersion);
        return client;
    }
}
