// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the ServiceBusManagementClient type. */
public final class ServiceBusManagementClientImpl {
    /** The proxy service used to perform REST calls. */
    private final ServiceBusManagementClientService service;

    /** The Service Bus fully qualified domain name. */
    private final String endpoint;

    /**
     * Gets The Service Bus fully qualified domain name.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The EntitiesImpl object to access its operations. */
    private final EntitiesImpl entities;

    /**
     * Gets the EntitiesImpl object to access its operations.
     *
     * @return the EntitiesImpl object.
     */
    public EntitiesImpl getEntities() {
        return this.entities;
    }

    /** The SubscriptionsImpl object to access its operations. */
    private final SubscriptionsImpl subscriptions;

    /**
     * Gets the SubscriptionsImpl object to access its operations.
     *
     * @return the SubscriptionsImpl object.
     */
    public SubscriptionsImpl getSubscriptions() {
        return this.subscriptions;
    }

    /** The RulesImpl object to access its operations. */
    private final RulesImpl rules;

    /**
     * Gets the RulesImpl object to access its operations.
     *
     * @return the RulesImpl object.
     */
    public RulesImpl getRules() {
        return this.rules;
    }

    /** The NamespacesImpl object to access its operations. */
    private final NamespacesImpl namespaces;

    /**
     * Gets the NamespacesImpl object to access its operations.
     *
     * @return the NamespacesImpl object.
     */
    public NamespacesImpl getNamespaces() {
        return this.namespaces;
    }

    /** Initializes an instance of ServiceBusManagementClient client. */
    ServiceBusManagementClientImpl(String endpoint, String apiVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    /**
     * Initializes an instance of ServiceBusManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     */
    ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.serializerAdapter = serializerAdapter;
        this.entities = new EntitiesImpl(this);
        this.subscriptions = new SubscriptionsImpl(this);
        this.rules = new RulesImpl(this);
        this.namespaces = new NamespacesImpl(this);
        this.service =
                RestProxy.create(
                        ServiceBusManagementClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for ServiceBusManagementClient to be used by the proxy service to perform
     * REST calls.
     */
    @Host("https://{endpoint}")
    @ServiceInterface(name = "ServiceBusManagement")
    private interface ServiceBusManagementClientService {
        @Get("/{topicName}/subscriptions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ServiceBusManagementErrorException.class)
        Mono<Response<Object>> listSubscriptions(
                @HostParam("endpoint") String endpoint,
                @PathParam("topicName") String topicName,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                Context context);

        @Get("/{topicName}/subscriptions/{subscriptionName}/rules")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ServiceBusManagementErrorException.class)
        Mono<Response<Object>> listRules(
                @HostParam("endpoint") String endpoint,
                @PathParam("topicName") String topicName,
                @PathParam("subscriptionName") String subscriptionName,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                Context context);

        @Get("/$Resources/{entityType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ServiceBusManagementErrorException.class)
        Mono<Response<Object>> listEntities(
                @HostParam("endpoint") String endpoint,
                @PathParam("entityType") String entityType,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                Context context);
    }

    /**
     * Get the details about the subscriptions of the given topic.
     *
     * @param topicName name of the topic.
     * @param skip The skip parameter.
     * @param top The top parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ServiceBusManagementErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details about the subscriptions of the given topic.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Object>> listSubscriptionsWithResponseAsync(
            String topicName, Integer skip, Integer top, Context context) {
        return service.listSubscriptions(this.getEndpoint(), topicName, skip, top, this.getApiVersion(), context);
    }

    /**
     * Get the details about the rules of the given topic subscription.
     *
     * @param topicName name of the topic.
     * @param subscriptionName name of the subscription.
     * @param skip The skip parameter.
     * @param top The top parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ServiceBusManagementErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details about the rules of the given topic subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Object>> listRulesWithResponseAsync(
            String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        return service.listRules(
                this.getEndpoint(), topicName, subscriptionName, skip, top, this.getApiVersion(), context);
    }

    /**
     * Get the details about the entities of the given Service Bus namespace.
     *
     * @param entityType List all queues or all topics of the service bus. Value can be "queues" or "topics".
     * @param skip The skip parameter.
     * @param top The top parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ServiceBusManagementErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details about the entities of the given Service Bus namespace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Object>> listEntitiesWithResponseAsync(
            String entityType, Integer skip, Integer top, Context context) {
        return service.listEntities(this.getEndpoint(), entityType, skip, top, this.getApiVersion(), context);
    }
}
