/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusSharedKeyCredential;
import java.net.URL;
import reactor.core.publisher.Mono;

public final class ServiceBusSupplementaryAuthHeaderPolicy
implements HttpPipelinePolicy {
    private final TokenCredential tokenCredential;

    public ServiceBusSupplementaryAuthHeaderPolicy(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpHeaders headers = context.getHttpRequest().getHeaders();
        if (headers.get(ServiceBusConstants.SERVICE_BUS_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME) != null || headers.get(ServiceBusConstants.SERVICE_BUS_DLQ_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME) != null) {
            String scope;
            if (this.tokenCredential instanceof ServiceBusSharedKeyCredential) {
                URL url = context.getHttpRequest().getUrl();
                scope = String.format("%s://%s", url.getProtocol(), url.getHost());
            } else {
                scope = "https://servicebus.azure.net/.default";
            }
            return this.tokenCredential.getToken(new TokenRequestContext().addScopes(new String[]{scope})).flatMap(token -> {
                if (headers.get(ServiceBusConstants.SERVICE_BUS_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME) != null) {
                    headers.set(ServiceBusConstants.SERVICE_BUS_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME, token.getToken());
                }
                if (headers.get(ServiceBusConstants.SERVICE_BUS_DLQ_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME) != null) {
                    headers.set(ServiceBusConstants.SERVICE_BUS_DLQ_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME, token.getToken());
                }
                return next.process();
            });
        }
        return next.process();
    }
}

