/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusMeter;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ServiceBusSenderInstrumentation {
    private final ServiceBusMeter meter;
    private final ServiceBusTracer tracer;

    public ServiceBusSenderInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityPath) {
        this.tracer = new ServiceBusTracer(tracer, fullyQualifiedName, entityPath);
        this.meter = new ServiceBusMeter(meter, fullyQualifiedName, entityPath, null);
    }

    public ServiceBusTracer getTracer() {
        return this.tracer;
    }

    public <T> Mono<T> instrumentSendBatch(String spanName, Mono<T> publisher, List<ServiceBusMessage> batch) {
        if (!this.tracer.isEnabled() && !this.meter.isBatchSendEnabled()) {
            return publisher;
        }
        if (this.tracer.isEnabled()) {
            return Mono.defer(() -> {
                Context span = this.tracer.startSpanWithLinks(spanName, ServiceBusTracer.OperationName.PUBLISH, batch, Context.NONE);
                return publisher.doOnEach(signal -> {
                    this.meter.reportBatchSend(batch.size(), signal.getThrowable(), false, span);
                    this.tracer.endSpan(signal.getThrowable(), span, null);
                }).doOnCancel(() -> {
                    this.meter.reportBatchSend(batch.size(), null, true, span);
                    this.tracer.cancelSpan(span);
                });
            });
        }
        return publisher.doOnEach(signal -> this.meter.reportBatchSend(batch.size(), signal.getThrowable(), false, Context.NONE)).doOnCancel(() -> this.meter.reportBatchSend(batch.size(), null, true, Context.NONE));
    }
}

