/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusErrorSource;
import com.azure.messaging.servicebus.ServiceBusException;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;

public final class ServiceBusMessageBatch {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusMessageBatch.class);
    private final int maxMessageSize;
    private final ErrorContextProvider contextProvider;
    private final MessageSerializer serializer;
    private final List<ServiceBusMessage> serviceBusMessageList;
    private final byte[] eventBytes;
    private int sizeInBytes;
    private final ServiceBusTracer tracer;
    private final boolean isV2;

    ServiceBusMessageBatch(boolean isV2, int maxMessageSize, ErrorContextProvider contextProvider, ServiceBusTracer tracer, MessageSerializer serializer) {
        this.maxMessageSize = maxMessageSize;
        this.contextProvider = contextProvider;
        this.serializer = serializer;
        this.serviceBusMessageList = new ArrayList<ServiceBusMessage>();
        this.sizeInBytes = maxMessageSize / 65536 * 1024;
        this.eventBytes = isV2 ? new byte[]{} : new byte[maxMessageSize];
        this.tracer = tracer;
        this.isV2 = isV2;
    }

    public int getCount() {
        return this.serviceBusMessageList.size();
    }

    public int getMaxSizeInBytes() {
        return this.maxMessageSize;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean tryAddMessage(ServiceBusMessage serviceBusMessage) {
        int size;
        if (serviceBusMessage == null) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new NullPointerException("'serviceBusMessage' cannot be null"));
        }
        this.tracer.reportMessageSpan(serviceBusMessage);
        try {
            size = this.getSize(serviceBusMessage, this.serviceBusMessageList.isEmpty());
        }
        catch (BufferOverflowException exception) {
            ServiceBusException ex = new ServiceBusException((Throwable)new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, String.format(Locale.US, "Size of the payload exceeded maximum message size: %s kb", this.maxMessageSize / 1024), this.contextProvider.getErrorContext()), ServiceBusErrorSource.SEND);
            throw LOGGER.logExceptionAsWarning((RuntimeException)((Object)ex));
        }
        if (this.sizeInBytes + size > this.maxMessageSize) {
            return false;
        }
        this.sizeInBytes += size;
        this.serviceBusMessageList.add(serviceBusMessage);
        return true;
    }

    List<ServiceBusMessage> getMessages() {
        return this.serviceBusMessageList;
    }

    private int getSize(ServiceBusMessage serviceBusMessage, boolean isFirst) {
        Objects.requireNonNull(serviceBusMessage, "'serviceBusMessage' cannot be null.");
        Message amqpMessage = this.serializer.serialize((Object)serviceBusMessage);
        int eventSize = this.encodedSize(amqpMessage);
        eventSize += 16;
        if (isFirst) {
            amqpMessage.setBody(null);
            amqpMessage.setApplicationProperties(null);
            amqpMessage.setProperties(null);
            amqpMessage.setDeliveryAnnotations(null);
            eventSize += this.encodedSize(amqpMessage);
        }
        return eventSize;
    }

    private int encodedSize(Message amqpMessage) {
        if (this.isV2) {
            int size = amqpMessage.encode((WritableBuffer)new DroppingWritableBuffer());
            if (size > this.maxMessageSize) {
                IndexOutOfBoundsException cause = new IndexOutOfBoundsException(String.format("Requested size (%d) exceeds the maximum allowed size (%d)", size, this.maxMessageSize));
                throw (BufferOverflowException)new BufferOverflowException().initCause(cause);
            }
            return size;
        }
        return amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
    }
}

