/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.Title;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntry;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TopicDescriptionFeed
implements XmlSerializable<TopicDescriptionFeed> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private Title title;
    private OffsetDateTime updated;
    private List<ResponseLink> link = new ArrayList<ResponseLink>();
    private List<TopicDescriptionEntry> entry = new ArrayList<TopicDescriptionEntry>();

    public String getId() {
        return this.id;
    }

    public TopicDescriptionFeed setId(String id) {
        this.id = id;
        return this;
    }

    public Title getTitle() {
        return this.title;
    }

    public TopicDescriptionFeed setTitle(Title title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public TopicDescriptionFeed setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public List<ResponseLink> getLink() {
        return this.link;
    }

    public TopicDescriptionFeed setLink(List<ResponseLink> link) {
        this.link = link;
        return this;
    }

    public List<TopicDescriptionEntry> getEntry() {
        return this.entry;
    }

    public TopicDescriptionFeed setEntry(List<TopicDescriptionEntry> entry) {
        this.entry = entry;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "feed" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        if (this.link != null) {
            for (ResponseLink responseLink : this.link) {
                xmlWriter.writeXml((XmlSerializable)responseLink, "link");
            }
        }
        if (this.entry != null) {
            for (TopicDescriptionEntry topicDescriptionEntry : this.entry) {
                xmlWriter.writeXml((XmlSerializable)topicDescriptionEntry, "entry");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static TopicDescriptionFeed fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TopicDescriptionFeed.fromXml(xmlReader, null);
    }

    public static TopicDescriptionFeed fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "feed" : rootElementName;
        return (TopicDescriptionFeed)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            TopicDescriptionFeed deserializedTopicDescriptionFeed = new TopicDescriptionFeed();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionFeed.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionFeed.title = Title.fromXml(reader, "title");
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionFeed.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("link".equals(elementName.getLocalPart())) {
                    deserializedTopicDescriptionFeed.link.add(ResponseLink.fromXml(reader, "link"));
                    continue;
                }
                if ("entry".equals(elementName.getLocalPart())) {
                    deserializedTopicDescriptionFeed.entry.add(TopicDescriptionEntry.fromXml(reader, "entry"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTopicDescriptionFeed;
        });
    }
}

