/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.KeyValueImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SqlFilterImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TrueFilterImpl
extends SqlFilterImpl {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";

    @Override
    public TrueFilterImpl setSqlExpression(String sqlExpression) {
        super.setSqlExpression(sqlExpression);
        return this;
    }

    @Override
    public TrueFilterImpl setCompatibilityLevel(String compatibilityLevel) {
        super.setCompatibilityLevel(compatibilityLevel);
        return this;
    }

    @Override
    public TrueFilterImpl setParameters(List<KeyValueImpl> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public TrueFilterImpl setRequiresPreprocessing(Boolean requiresPreprocessing) {
        super.setRequiresPreprocessing(requiresPreprocessing);
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Filter" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", "TrueFilter");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SqlExpression", this.getSqlExpression());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CompatibilityLevel", this.getCompatibilityLevel());
        if (this.getParameters() != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Parameters");
            for (KeyValueImpl element : this.getParameters()) {
                xmlWriter.writeXml((XmlSerializable)element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresPreprocessing", this.isRequiresPreprocessing());
        return xmlWriter.writeEndElement();
    }

    public static TrueFilterImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TrueFilterImpl.fromXml(xmlReader, null);
    }

    public static TrueFilterImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Filter" : rootElementName;
        return (TrueFilterImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            TrueFilterImpl deserializedTrueFilter = new TrueFilterImpl();
            String discriminatorValue = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"TrueFilter".equals(discriminatorValue)) {
                throw new IllegalStateException("'type' was expected to be non-null and equal to 'TrueFilter'. The found 'type' was '" + discriminatorValue + "'.");
            }
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SqlExpression".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTrueFilter.setSqlExpression(reader.getStringElement());
                    continue;
                }
                if ("CompatibilityLevel".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTrueFilter.setCompatibilityLevel(reader.getStringElement());
                    continue;
                }
                if ("Parameters".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedTrueFilter.getParameters() == null) {
                                deserializedTrueFilter.setParameters((List)new ArrayList());
                            }
                            deserializedTrueFilter.getParameters().add(KeyValueImpl.fromXml(reader, "KeyValueOfstringanyType"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("RequiresPreprocessing".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTrueFilter.setRequiresPreprocessing((Boolean)reader.getNullableElement(Boolean::parseBoolean));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTrueFilter;
        });
    }
}

