// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.CoreToCodegenBridgeUtils;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Description of a Service Bus subscription resource.
 */
@Fluent
public final class SubscriptionDescriptionImpl implements XmlSerializable<SubscriptionDescriptionImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other
     * receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
     */
    private Duration lockDuration;

    /*
     * A value that indicates whether the subscription supports the concept of sessions.
     */
    private Boolean requiresSession;

    /*
     * ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting
     * from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a
     * message itself.
     */
    private Duration defaultMessageTimeToLive;

    /*
     * A value that indicates whether this subscription has dead letter support when a message expires.
     */
    private Boolean deadLetteringOnMessageExpiration;

    /*
     * A value that indicates whether this subscription has dead letter support when a message expires.
     */
    private Boolean deadLetteringOnFilterEvaluationExceptions;

    /*
     * The number of messages in the subscription.
     */
    private Integer messageCount;

    /*
     * The maximum delivery count. A message is automatically deadlettered after this number of deliveries. Default
     * value is 10.
     */
    private Integer maxDeliveryCount;

    /*
     * Value that indicates whether server-side batched operations are enabled.
     */
    private Boolean enableBatchedOperations;

    /*
     * Status of a Service Bus resource
     */
    private EntityStatus status;

    /*
     * The name of the recipient entity to which all the messages sent to the subscription are forwarded to.
     */
    private String forwardTo;

    /*
     * The exact time the subscription was created.
     */
    private OffsetDateTime createdAt;

    /*
     * The exact time a message was updated in the subscription.
     */
    private OffsetDateTime updatedAt;

    /*
     * Last time a message was sent, or the last time there was a receive request to this subscription.
     */
    private OffsetDateTime accessedAt;

    /*
     * Details about the message counts in entity.
     */
    private MessageCountDetailsImpl messageCountDetails;

    /*
     * Metadata associated with the subscription. Maximum number of characters is 1024.
     */
    private String userMetadata;

    /*
     * The name of the recipient entity to which all the messages sent to the subscription are forwarded to.
     */
    private String forwardDeadLetteredMessagesTo;

    /*
     * ISO 8601 timeSpan idle interval after which the subscription is automatically deleted. The minimum duration is 5
     * minutes.
     */
    private Duration autoDeleteOnIdle;

    /*
     * Availability status of the entity
     */
    private EntityAvailabilityStatusImpl entityAvailabilityStatus;

    /*
     * The default rule description.
     */
    private RuleDescriptionImpl defaultRuleDescription;

    /**
     * Creates an instance of SubscriptionDescription class.
     */
    public SubscriptionDescriptionImpl() {
    }

    /**
     * Get the lockDuration property: ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the
     * message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1
     * minute.
     * 
     * @return the lockDuration value.
     */
    public Duration getLockDuration() {
        return this.lockDuration;
    }

    /**
     * Set the lockDuration property: ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the
     * message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1
     * minute.
     * 
     * @param lockDuration the lockDuration value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    /**
     * Get the requiresSession property: A value that indicates whether the subscription supports the concept of
     * sessions.
     * 
     * @return the requiresSession value.
     */
    public Boolean isRequiresSession() {
        return this.requiresSession;
    }

    /**
     * Set the requiresSession property: A value that indicates whether the subscription supports the concept of
     * sessions.
     * 
     * @param requiresSession the requiresSession value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    /**
     * Get the defaultMessageTimeToLive property: ISO 8601 default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default
     * value used when TimeToLive is not set on a message itself.
     * 
     * @return the defaultMessageTimeToLive value.
     */
    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    /**
     * Set the defaultMessageTimeToLive property: ISO 8601 default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default
     * value used when TimeToLive is not set on a message itself.
     * 
     * @param defaultMessageTimeToLive the defaultMessageTimeToLive value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    /**
     * Get the deadLetteringOnMessageExpiration property: A value that indicates whether this subscription has dead
     * letter support when a message expires.
     * 
     * @return the deadLetteringOnMessageExpiration value.
     */
    public Boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    /**
     * Set the deadLetteringOnMessageExpiration property: A value that indicates whether this subscription has dead
     * letter support when a message expires.
     * 
     * @param deadLetteringOnMessageExpiration the deadLetteringOnMessageExpiration value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    /**
     * Get the deadLetteringOnFilterEvaluationExceptions property: A value that indicates whether this subscription has
     * dead letter support when a message expires.
     * 
     * @return the deadLetteringOnFilterEvaluationExceptions value.
     */
    public Boolean isDeadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    /**
     * Set the deadLetteringOnFilterEvaluationExceptions property: A value that indicates whether this subscription has
     * dead letter support when a message expires.
     * 
     * @param deadLetteringOnFilterEvaluationExceptions the deadLetteringOnFilterEvaluationExceptions value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl
        setDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    /**
     * Get the messageCount property: The number of messages in the subscription.
     * 
     * @return the messageCount value.
     */
    public Integer getMessageCount() {
        return this.messageCount;
    }

    /**
     * Set the messageCount property: The number of messages in the subscription.
     * 
     * @param messageCount the messageCount value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    /**
     * Get the maxDeliveryCount property: The maximum delivery count. A message is automatically deadlettered after
     * this number of deliveries. Default value is 10.
     * 
     * @return the maxDeliveryCount value.
     */
    public Integer getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    /**
     * Set the maxDeliveryCount property: The maximum delivery count. A message is automatically deadlettered after
     * this number of deliveries. Default value is 10.
     * 
     * @param maxDeliveryCount the maxDeliveryCount value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    /**
     * Get the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     * 
     * @return the enableBatchedOperations value.
     */
    public Boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    /**
     * Set the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     * 
     * @param enableBatchedOperations the enableBatchedOperations value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    /**
     * Get the status property: Status of a Service Bus resource.
     * 
     * @return the status value.
     */
    public EntityStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Status of a Service Bus resource.
     * 
     * @param status the status value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the forwardTo property: The name of the recipient entity to which all the messages sent to the subscription
     * are forwarded to.
     * 
     * @return the forwardTo value.
     */
    public String getForwardTo() {
        return this.forwardTo;
    }

    /**
     * Set the forwardTo property: The name of the recipient entity to which all the messages sent to the subscription
     * are forwarded to.
     * 
     * @param forwardTo the forwardTo value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    /**
     * Get the createdAt property: The exact time the subscription was created.
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    /**
     * Set the createdAt property: The exact time the subscription was created.
     * 
     * @param createdAt the createdAt value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Get the updatedAt property: The exact time a message was updated in the subscription.
     * 
     * @return the updatedAt value.
     */
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * Set the updatedAt property: The exact time a message was updated in the subscription.
     * 
     * @param updatedAt the updatedAt value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * Get the accessedAt property: Last time a message was sent, or the last time there was a receive request to this
     * subscription.
     * 
     * @return the accessedAt value.
     */
    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    /**
     * Set the accessedAt property: Last time a message was sent, or the last time there was a receive request to this
     * subscription.
     * 
     * @param accessedAt the accessedAt value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setAccessedAt(OffsetDateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    /**
     * Get the messageCountDetails property: Details about the message counts in entity.
     * 
     * @return the messageCountDetails value.
     */
    public MessageCountDetailsImpl getMessageCountDetails() {
        return this.messageCountDetails;
    }

    /**
     * Set the messageCountDetails property: Details about the message counts in entity.
     * 
     * @param messageCountDetails the messageCountDetails value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setMessageCountDetails(MessageCountDetailsImpl messageCountDetails) {
        this.messageCountDetails = messageCountDetails;
        return this;
    }

    /**
     * Get the userMetadata property: Metadata associated with the subscription. Maximum number of characters is 1024.
     * 
     * @return the userMetadata value.
     */
    public String getUserMetadata() {
        return this.userMetadata;
    }

    /**
     * Set the userMetadata property: Metadata associated with the subscription. Maximum number of characters is 1024.
     * 
     * @param userMetadata the userMetadata value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    /**
     * Get the forwardDeadLetteredMessagesTo property: The name of the recipient entity to which all the messages sent
     * to the subscription are forwarded to.
     * 
     * @return the forwardDeadLetteredMessagesTo value.
     */
    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    /**
     * Set the forwardDeadLetteredMessagesTo property: The name of the recipient entity to which all the messages sent
     * to the subscription are forwarded to.
     * 
     * @param forwardDeadLetteredMessagesTo the forwardDeadLetteredMessagesTo value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    /**
     * Get the autoDeleteOnIdle property: ISO 8601 timeSpan idle interval after which the subscription is automatically
     * deleted. The minimum duration is 5 minutes.
     * 
     * @return the autoDeleteOnIdle value.
     */
    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    /**
     * Set the autoDeleteOnIdle property: ISO 8601 timeSpan idle interval after which the subscription is automatically
     * deleted. The minimum duration is 5 minutes.
     * 
     * @param autoDeleteOnIdle the autoDeleteOnIdle value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    /**
     * Get the entityAvailabilityStatus property: Availability status of the entity.
     * 
     * @return the entityAvailabilityStatus value.
     */
    public EntityAvailabilityStatusImpl getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    /**
     * Set the entityAvailabilityStatus property: Availability status of the entity.
     * 
     * @param entityAvailabilityStatus the entityAvailabilityStatus value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl
        setEntityAvailabilityStatus(EntityAvailabilityStatusImpl entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    /**
     * Get the defaultRuleDescription property: The default rule description.
     * 
     * @return the defaultRuleDescription value.
     */
    public RuleDescriptionImpl getDefaultRuleDescription() {
        return this.defaultRuleDescription;
    }

    /**
     * Set the defaultRuleDescription property: The default rule description.
     * 
     * @param defaultRuleDescription the defaultRuleDescription value to set.
     * @return the SubscriptionDescription object itself.
     */
    public SubscriptionDescriptionImpl setDefaultRuleDescription(RuleDescriptionImpl defaultRuleDescription) {
        this.defaultRuleDescription = defaultRuleDescription;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SubscriptionDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "LockDuration",
            CoreToCodegenBridgeUtils.durationToStringWithDays(this.lockDuration));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresSession",
            this.requiresSession);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DefaultMessageTimeToLive",
            CoreToCodegenBridgeUtils.durationToStringWithDays(this.defaultMessageTimeToLive));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnMessageExpiration",
            this.deadLetteringOnMessageExpiration);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT,
            "DeadLetteringOnFilterEvaluationExceptions", this.deadLetteringOnFilterEvaluationExceptions);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessageCount", this.messageCount);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxDeliveryCount",
            this.maxDeliveryCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableBatchedOperations",
            this.enableBatchedOperations);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Status",
            this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardTo", this.forwardTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt",
            this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UpdatedAt",
            this.updatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessedAt",
            this.accessedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedAt));
        xmlWriter.writeXml(this.messageCountDetails, "CountDetails");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UserMetadata", this.userMetadata);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardDeadLetteredMessagesTo",
            this.forwardDeadLetteredMessagesTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AutoDeleteOnIdle",
            CoreToCodegenBridgeUtils.durationToStringWithDays(this.autoDeleteOnIdle));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EntityAvailabilityStatus",
            this.entityAvailabilityStatus == null ? null : this.entityAvailabilityStatus.toString());
        xmlWriter.writeXml(this.defaultRuleDescription, "DefaultRuleDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of SubscriptionDescription from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of SubscriptionDescription if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the SubscriptionDescription.
     */
    public static SubscriptionDescriptionImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of SubscriptionDescription from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of SubscriptionDescription if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the SubscriptionDescription.
     */
    public static SubscriptionDescriptionImpl fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "SubscriptionDescription" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SubscriptionDescriptionImpl deserializedSubscriptionDescription = new SubscriptionDescriptionImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("LockDuration".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.lockDuration = reader.getNullableElement(Duration::parse);
                } else if ("RequiresSession".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.requiresSession
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DefaultMessageTimeToLive".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.defaultMessageTimeToLive
                        = reader.getNullableElement(Duration::parse);
                } else if ("DeadLetteringOnMessageExpiration".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.deadLetteringOnMessageExpiration
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DeadLetteringOnFilterEvaluationExceptions".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.deadLetteringOnFilterEvaluationExceptions
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("MessageCount".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.messageCount = reader.getNullableElement(Integer::parseInt);
                } else if ("MaxDeliveryCount".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.maxDeliveryCount = reader.getNullableElement(Integer::parseInt);
                } else if ("EnableBatchedOperations".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.enableBatchedOperations
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("Status".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.status = EntityStatus.fromString(reader.getStringElement());
                } else if ("ForwardTo".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.forwardTo = reader.getStringElement();
                } else if ("CreatedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.createdAt
                        = reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                } else if ("UpdatedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.updatedAt
                        = reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                } else if ("AccessedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.accessedAt
                        = reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                } else if ("CountDetails".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.messageCountDetails
                        = MessageCountDetailsImpl.fromXml(reader, "CountDetails");
                } else if ("UserMetadata".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.userMetadata = reader.getStringElement();
                } else if ("ForwardDeadLetteredMessagesTo".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.forwardDeadLetteredMessagesTo = reader.getStringElement();
                } else if ("AutoDeleteOnIdle".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.autoDeleteOnIdle = reader.getNullableElement(Duration::parse);
                } else if ("EntityAvailabilityStatus".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.entityAvailabilityStatus
                        = EntityAvailabilityStatusImpl.fromString(reader.getStringElement());
                } else if ("DefaultRuleDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.defaultRuleDescription
                        = RuleDescriptionImpl.fromXml(reader, "DefaultRuleDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedSubscriptionDescription;
        });
    }
}
