// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * TopicDescription for the new topic.
 */
@Fluent
public final class CreateTopicBodyContentImpl implements XmlSerializable<CreateTopicBodyContentImpl> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * MIME type of content.
     */
    private String type;

    /*
     * Topic information to create.
     */
    private TopicDescriptionImpl topicDescription;

    /**
     * Creates an instance of CreateTopicBodyContent class.
     */
    public CreateTopicBodyContentImpl() {
    }

    /**
     * Get the type property: MIME type of content.
     * 
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: MIME type of content.
     * 
     * @param type the type value to set.
     * @return the CreateTopicBodyContent object itself.
     */
    public CreateTopicBodyContentImpl setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the topicDescription property: Topic information to create.
     * 
     * @return the topicDescription value.
     */
    public TopicDescriptionImpl getTopicDescription() {
        return this.topicDescription;
    }

    /**
     * Set the topicDescription property: Topic information to create.
     * 
     * @param topicDescription the topicDescription value to set.
     * @return the CreateTopicBodyContent object itself.
     */
    public CreateTopicBodyContentImpl setTopicDescription(TopicDescriptionImpl topicDescription) {
        this.topicDescription = topicDescription;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "CreateTopicBodyContent" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.topicDescription, "TopicDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of CreateTopicBodyContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of CreateTopicBodyContent if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the CreateTopicBodyContent.
     */
    public static CreateTopicBodyContentImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of CreateTopicBodyContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of CreateTopicBodyContent if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the CreateTopicBodyContent.
     */
    public static CreateTopicBodyContentImpl fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "CreateTopicBodyContent" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            CreateTopicBodyContentImpl deserializedCreateTopicBodyContent = new CreateTopicBodyContentImpl();
            deserializedCreateTopicBodyContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("TopicDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCreateTopicBodyContent.topicDescription
                        = TopicDescriptionImpl.fromXml(reader, "TopicDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedCreateTopicBodyContent;
        });
    }
}
