// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/** The SqlRuleAction model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("SqlRuleAction")
@JacksonXmlRootElement(localName = "SqlRuleAction")
@Fluent
public final class SqlRuleActionImpl extends RuleActionImpl {

    /*
     * The sqlExpression property.
     */
    @JacksonXmlProperty(
            localName = "SqlExpression",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String sqlExpression;

    /*
     * The compatibilityLevel property.
     */
    @JacksonXmlProperty(
            localName = "CompatibilityLevel",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String compatibilityLevel;

    private static final class ParametersWrapper {

        @JacksonXmlProperty(
                localName = "KeyValueOfstringanyType",
                namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
        private final List<KeyValueImpl> items;

        @JsonCreator
        private ParametersWrapper(
                @JacksonXmlProperty(
                                localName = "KeyValueOfstringanyType",
                                namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
                        List<KeyValueImpl> items) {
            this.items = items;
        }
    }

    /*
     * The parameters property.
     */
    @JacksonXmlProperty(
            localName = "Parameters",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private ParametersWrapper parameters;

    /*
     * The requiresPreprocessing property.
     */
    @JacksonXmlProperty(
            localName = "RequiresPreprocessing",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private Boolean requiresPreprocessing;

    /** Creates an instance of SqlRuleAction class. */
    public SqlRuleActionImpl() {}

    /**
     * Get the sqlExpression property: The sqlExpression property.
     *
     * @return the sqlExpression value.
     */
    public String getSqlExpression() {
        return this.sqlExpression;
    }

    /**
     * Set the sqlExpression property: The sqlExpression property.
     *
     * @param sqlExpression the sqlExpression value to set.
     * @return the SqlRuleAction object itself.
     */
    public SqlRuleActionImpl setSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    /**
     * Get the compatibilityLevel property: The compatibilityLevel property.
     *
     * @return the compatibilityLevel value.
     */
    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    /**
     * Set the compatibilityLevel property: The compatibilityLevel property.
     *
     * @param compatibilityLevel the compatibilityLevel value to set.
     * @return the SqlRuleAction object itself.
     */
    public SqlRuleActionImpl setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    /**
     * Get the parameters property: The parameters property.
     *
     * @return the parameters value.
     */
    public List<KeyValueImpl> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ParametersWrapper(new ArrayList<KeyValueImpl>());
        }
        return this.parameters.items;
    }

    /**
     * Set the parameters property: The parameters property.
     *
     * @param parameters the parameters value to set.
     * @return the SqlRuleAction object itself.
     */
    public SqlRuleActionImpl setParameters(List<KeyValueImpl> parameters) {
        this.parameters = new ParametersWrapper(parameters);
        return this;
    }

    /**
     * Get the requiresPreprocessing property: The requiresPreprocessing property.
     *
     * @return the requiresPreprocessing value.
     */
    public Boolean isRequiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    /**
     * Set the requiresPreprocessing property: The requiresPreprocessing property.
     *
     * @param requiresPreprocessing the requiresPreprocessing value to set.
     * @return the SqlRuleAction object itself.
     */
    public SqlRuleActionImpl setRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }
}
