// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** TopicDescription for the new topic. */
@JacksonXmlRootElement(localName = "CreateTopicBodyContent", namespace = "http://www.w3.org/2005/Atom")
@Fluent
public final class CreateTopicBodyContentImpl {

    /*
     * MIME type of content.
     */
    @JacksonXmlProperty(localName = "type", isAttribute = true)
    private String type;

    /*
     * Topic information to create.
     */
    @JacksonXmlProperty(
            localName = "TopicDescription",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private TopicDescriptionImpl topicDescription;

    /** Creates an instance of CreateTopicBodyContent class. */
    public CreateTopicBodyContentImpl() {}

    /**
     * Get the type property: MIME type of content.
     *
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: MIME type of content.
     *
     * @param type the type value to set.
     * @return the CreateTopicBodyContent object itself.
     */
    public CreateTopicBodyContentImpl setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the topicDescription property: Topic information to create.
     *
     * @return the topicDescription value.
     */
    public TopicDescriptionImpl getTopicDescription() {
        return this.topicDescription;
    }

    /**
     * Set the topicDescription property: Topic information to create.
     *
     * @param topicDescription the topicDescription value to set.
     * @return the CreateTopicBodyContent object itself.
     */
    public CreateTopicBodyContentImpl setTopicDescription(TopicDescriptionImpl topicDescription) {
        this.topicDescription = topicDescription;
        return this;
    }
}
