/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ServiceBusTracer {
    public static final String START_TIME_KEY = "span-start-time";
    public static final String REACTOR_PARENT_TRACE_CONTEXT_KEY = "otel-context-key";
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusTracer.class);
    protected static final String TRACEPARENT_KEY = "traceparent";
    protected static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    protected final Tracer tracer;
    protected final String fullyQualifiedName;
    protected final String entityPath;

    public ServiceBusTracer(Tracer tracer, String fullyQualifiedName, String entityPath) {
        this.tracer = IS_TRACING_DISABLED ? null : tracer;
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "'fullyQualifiedName' cannot be null");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null");
    }

    public static Tracer getDefaultTracer() {
        ServiceLoader<Tracer> tracers = ServiceLoader.load(Tracer.class);
        Iterator it = tracers.iterator();
        return it.hasNext() ? (Tracer)it.next() : null;
    }

    public boolean isEnabled() {
        return this.tracer != null;
    }

    public AutoCloseable makeSpanCurrent(com.azure.core.util.Context span) {
        return this.tracer == null ? NOOP_CLOSEABLE : this.tracer.makeSpanCurrent(span);
    }

    public <T> Mono<T> traceMono(String spanName, Mono<T> publisher) {
        if (this.tracer != null) {
            return publisher.doOnEach(this::endSpan).contextWrite(ctx -> ctx.put((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.tracer.start(spanName, this.setAttributes(com.azure.core.util.Context.NONE), ProcessKind.SEND)));
        }
        return publisher;
    }

    public <T> Mono<T> traceMonoWithLink(String spanName, Mono<T> publisher, ServiceBusReceivedMessage message, com.azure.core.util.Context messageContext) {
        if (this.tracer != null) {
            return publisher.doOnEach(this::endSpan).contextWrite(ctx -> ctx.put((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.startSpanWithLink(spanName, message, messageContext, com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    public <T> Mono<T> traceMonoWithLink(String spanName, Mono<T> publisher, ServiceBusMessage message, com.azure.core.util.Context messageContext) {
        if (this.tracer != null) {
            return publisher.doOnEach(this::endSpan).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.startSpanWithLink(spanName, message, messageContext, com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    public <T> Flux<T> traceFluxWithLinks(String spanName, Flux<T> publisher, List<ServiceBusMessage> batch, Function<ServiceBusMessage, com.azure.core.util.Context> getContext) {
        if (this.tracer != null) {
            return publisher.doOnEach(this::endSpan).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.startSpanWithLinks(spanName, batch, getContext, com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan(Throwable throwable, com.azure.core.util.Context span, AutoCloseable scope) {
        if (this.tracer != null) {
            String errorCondition = "success";
            if (throwable instanceof AmqpException) {
                AmqpException exception = (AmqpException)throwable;
                errorCondition = exception.getErrorCondition().getErrorCondition();
            }
            try {
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Exception e) {
                LOGGER.warning("Can't close scope", new Object[]{e});
            }
            finally {
                this.tracer.end(errorCondition, throwable, span);
            }
        }
    }

    public void reportMessageSpan(ServiceBusMessage serviceBusMessage, com.azure.core.util.Context messageContext) {
        if (this.tracer == null || messageContext == null || messageContext.getData((Object)"span-context").isPresent()) {
            return;
        }
        String traceparent = ServiceBusTracer.getTraceparent(serviceBusMessage.getApplicationProperties());
        if (traceparent != null) {
            return;
        }
        com.azure.core.util.Context newMessageContext = this.setAttributes(messageContext);
        com.azure.core.util.Context eventSpanContext = this.tracer.start("ServiceBus.message", newMessageContext, ProcessKind.MESSAGE);
        Optional traceparentOpt = eventSpanContext.getData((Object)"Diagnostic-Id");
        if (traceparentOpt.isPresent()) {
            serviceBusMessage.getApplicationProperties().put("Diagnostic-Id", traceparentOpt.get().toString());
            serviceBusMessage.getApplicationProperties().put(TRACEPARENT_KEY, traceparentOpt.get().toString());
            this.endSpan(null, eventSpanContext, null);
            Optional spanContext = eventSpanContext.getData((Object)"span-context");
            if (spanContext.isPresent()) {
                serviceBusMessage.addContext("span-context", spanContext.get());
            }
        }
    }

    public Mono<ServiceBusReceivedMessage> traceManagementReceive(String spanName, Mono<ServiceBusReceivedMessage> publisher, Function<ServiceBusReceivedMessage, com.azure.core.util.Context> getMessageContext) {
        if (this.tracer != null) {
            AtomicLong startTime = new AtomicLong();
            AtomicReference message = new AtomicReference();
            return publisher.doOnEach(signal -> {
                if (signal.hasValue()) {
                    message.set((ServiceBusReceivedMessage)signal.get());
                }
                if (signal.isOnComplete() || signal.isOnError()) {
                    ServiceBusReceivedMessage msg = (ServiceBusReceivedMessage)message.get();
                    com.azure.core.util.Context messageContext = msg == null ? null : (com.azure.core.util.Context)getMessageContext.apply(msg);
                    com.azure.core.util.Context span = this.startSpanWithLink(spanName, msg, messageContext, new com.azure.core.util.Context((Object)START_TIME_KEY, (Object)startTime.get()));
                    this.endSpan(null, span, null);
                }
            }).doOnSubscribe(s -> startTime.set(Instant.now().toEpochMilli()));
        }
        return publisher;
    }

    public Flux<ServiceBusReceivedMessage> traceSyncReceive(String spanName, Flux<ServiceBusReceivedMessage> messages) {
        if (this.tracer != null) {
            return messages.doOnEach(signal -> {
                com.azure.core.util.Context builder = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                if (signal.hasValue()) {
                    ServiceBusReceivedMessage message = (ServiceBusReceivedMessage)signal.get();
                    if (message != null) {
                        this.addLink(message.getApplicationProperties(), message.getEnqueuedTime(), builder, com.azure.core.util.Context.NONE);
                    }
                } else if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = this.tracer.start(spanName, builder, ProcessKind.SEND);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.getBuilder(spanName, new com.azure.core.util.Context((Object)START_TIME_KEY, (Object)Instant.now().toEpochMilli()))));
        }
        return messages;
    }

    public com.azure.core.util.Context startSpanWithLinks(String spanName, List<ServiceBusMessage> batch, Function<ServiceBusMessage, com.azure.core.util.Context> getMessageContext, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            com.azure.core.util.Context spanBuilder = this.getBuilder(spanName, parent);
            for (ServiceBusMessage message : batch) {
                this.createMessageSpanAndAddLink(message, spanBuilder, getMessageContext.apply(message));
            }
            return this.tracer.start(spanName, spanBuilder, ProcessKind.SEND);
        }
        return parent;
    }

    com.azure.core.util.Context startSpanWithLink(String spanName, ServiceBusReceivedMessage message, com.azure.core.util.Context messageContext, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            com.azure.core.util.Context spanBuilder = this.getBuilder(spanName, parent);
            if (message != null) {
                this.addLink(message.getApplicationProperties(), message.getEnqueuedTime(), spanBuilder, messageContext);
            }
            return this.tracer.start(spanName, spanBuilder, ProcessKind.SEND);
        }
        return parent;
    }

    com.azure.core.util.Context startProcessSpan(String spanName, ServiceBusReceivedMessage message, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            return this.tracer.start(spanName, this.setParentAndAttributes(message, parent), ProcessKind.PROCESS);
        }
        return parent;
    }

    private com.azure.core.util.Context startSpanWithLink(String name, ServiceBusMessage message, com.azure.core.util.Context messageContext, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            com.azure.core.util.Context spanBuilder = this.getBuilder(name, parent);
            if (message != null) {
                this.createMessageSpanAndAddLink(message, spanBuilder, messageContext);
            }
            return this.tracer.start(name, spanBuilder, ProcessKind.SEND);
        }
        return parent;
    }

    private void createMessageSpanAndAddLink(ServiceBusMessage message, com.azure.core.util.Context spanBuilder, com.azure.core.util.Context messageContext) {
        if (this.tracer != null) {
            String traceparent = ServiceBusTracer.getTraceparent(message.getApplicationProperties());
            if (traceparent == null) {
                this.reportMessageSpan(message, messageContext);
            }
            this.addLink(message.getApplicationProperties(), null, spanBuilder, messageContext);
        }
    }

    private void addLink(Map<String, Object> applicationProperties, OffsetDateTime enqueuedTime, com.azure.core.util.Context spanBuilder, com.azure.core.util.Context messageContext) {
        if (this.tracer != null) {
            Optional linkContext;
            Optional optional = linkContext = messageContext == null ? Optional.empty() : messageContext.getData((Object)"span-context");
            if (!linkContext.isPresent()) {
                String traceparent = ServiceBusTracer.getTraceparent(applicationProperties);
                com.azure.core.util.Context link = traceparent == null ? com.azure.core.util.Context.NONE : this.tracer.extractContext(traceparent, com.azure.core.util.Context.NONE);
                linkContext = link.getData((Object)"span-context");
            }
            if (enqueuedTime != null) {
                spanBuilder = spanBuilder.addData((Object)"x-opt-enqueued-time", (Object)enqueuedTime.toInstant().atOffset(ZoneOffset.UTC).toEpochSecond());
            }
            if (linkContext.isPresent()) {
                this.tracer.addLink(spanBuilder.addData((Object)"span-context", linkContext.get()));
            }
        }
    }

    private com.azure.core.util.Context setParentAndAttributes(ServiceBusReceivedMessage message, com.azure.core.util.Context parent) {
        if (message.getEnqueuedTime() != null) {
            parent = parent.addData((Object)"x-opt-enqueued-time", (Object)message.getEnqueuedTime().toInstant().atOffset(ZoneOffset.UTC).toEpochSecond());
        }
        parent = this.getParent(message.getApplicationProperties(), parent);
        return parent.addData((Object)"entity-path", (Object)this.entityPath).addData((Object)"hostname", (Object)this.fullyQualifiedName).addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
    }

    private com.azure.core.util.Context getParent(Map<String, Object> properties, com.azure.core.util.Context context) {
        if (this.tracer == null) {
            return context;
        }
        String traceparent = ServiceBusTracer.getTraceparent(properties);
        return traceparent == null ? context : this.tracer.extractContext(traceparent, context);
    }

    private static String getTraceparent(Map<String, Object> applicationProperties) {
        Object diagnosticId = applicationProperties.get("Diagnostic-Id");
        if (diagnosticId == null) {
            diagnosticId = applicationProperties.get(TRACEPARENT_KEY);
        }
        return diagnosticId == null ? null : diagnosticId.toString();
    }

    private com.azure.core.util.Context setAttributes(com.azure.core.util.Context context) {
        return context.addData((Object)"entity-path", (Object)this.entityPath).addData((Object)"hostname", (Object)this.fullyQualifiedName).addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
    }

    private com.azure.core.util.Context getBuilder(String spanName, com.azure.core.util.Context context) {
        if (this.tracer != null) {
            return this.setAttributes(this.tracer.getSharedSpanBuilder(spanName, context));
        }
        return context;
    }

    private <T> void endSpan(Signal<T> signal) {
        if (this.tracer == null) {
            return;
        }
        com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
        this.endSpan(signal.getThrowable(), span, null);
    }
}

