/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.exception.AzureException;
import com.azure.messaging.servicebus.ServiceBusErrorSource;
import com.azure.messaging.servicebus.ServiceBusFailureReason;

public final class ServiceBusException
extends AzureException {
    private final transient ServiceBusErrorSource errorSource;
    private final transient ServiceBusFailureReason reason;
    private final boolean isTransient;

    public ServiceBusException(Throwable throwable, ServiceBusErrorSource errorSource) {
        super(throwable.getMessage(), throwable);
        this.errorSource = errorSource;
        if (throwable instanceof AmqpException) {
            AmqpException amqpException = (AmqpException)throwable;
            this.reason = this.getServiceBusFailureReasonFromException(amqpException);
            this.isTransient = amqpException.isTransient();
        } else {
            this.reason = ServiceBusFailureReason.GENERAL_ERROR;
            this.isTransient = false;
        }
    }

    public ServiceBusFailureReason getReason() {
        return this.reason;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    ServiceBusErrorSource getErrorSource() {
        return this.errorSource;
    }

    private ServiceBusFailureReason getServiceBusFailureReasonFromException(AmqpException throwable) {
        AmqpErrorCondition errorCondition = throwable.getErrorCondition();
        if (errorCondition == null) {
            return ServiceBusFailureReason.GENERAL_ERROR;
        }
        switch (errorCondition) {
            case NOT_FOUND: {
                return ServiceBusFailureReason.MESSAGING_ENTITY_NOT_FOUND;
            }
            case MESSAGE_LOCK_LOST: {
                return ServiceBusFailureReason.MESSAGE_LOCK_LOST;
            }
            case MESSAGE_NOT_FOUND: {
                return ServiceBusFailureReason.MESSAGE_NOT_FOUND;
            }
            case LINK_PAYLOAD_SIZE_EXCEEDED: {
                return ServiceBusFailureReason.MESSAGE_SIZE_EXCEEDED;
            }
            case ENTITY_ALREADY_EXISTS: {
                return ServiceBusFailureReason.MESSAGING_ENTITY_ALREADY_EXISTS;
            }
            case ENTITY_DISABLED_ERROR: {
                return ServiceBusFailureReason.MESSAGING_ENTITY_DISABLED;
            }
            case RESOURCE_LIMIT_EXCEEDED: {
                return ServiceBusFailureReason.QUOTA_EXCEEDED;
            }
            case SERVER_BUSY_ERROR: {
                return ServiceBusFailureReason.SERVICE_BUSY;
            }
            case TIMEOUT_ERROR: {
                return ServiceBusFailureReason.SERVICE_TIMEOUT;
            }
            case SESSION_CANNOT_BE_LOCKED: {
                return ServiceBusFailureReason.SESSION_CANNOT_BE_LOCKED;
            }
            case SESSION_LOCK_LOST: {
                return ServiceBusFailureReason.SESSION_LOCK_LOST;
            }
            case UNAUTHORIZED_ACCESS: {
                return ServiceBusFailureReason.UNAUTHORIZED;
            }
            case PROTON_IO: {
                return ServiceBusFailureReason.SERVICE_COMMUNICATION_ERROR;
            }
        }
        return ServiceBusFailureReason.GENERAL_ERROR;
    }
}

