/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import reactor.core.scheduler.Scheduler;

class PartitionPump
implements AutoCloseable {
    private final String partitionId;
    private final EventHubConsumerAsyncClient client;
    private final Scheduler scheduler;
    private final ClientLogger logger = new ClientLogger(PartitionPump.class);

    PartitionPump(String partitionId, EventHubConsumerAsyncClient client, Scheduler scheduler) {
        this.partitionId = partitionId;
        this.client = client;
        this.scheduler = scheduler;
    }

    EventHubConsumerAsyncClient getClient() {
        return this.client;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception error) {
            this.logger.info("partitionId[{}] Exception occurred disposing of consumer client.", new Object[]{this.partitionId, error});
        }
        finally {
            this.scheduler.dispose();
        }
    }
}

