/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EventData {
    static final Set<String> RESERVED_SYSTEM_PROPERTIES;
    private final Map<String, Object> properties;
    private final BinaryData body;
    private final SystemProperties systemProperties;
    private Context context;

    public EventData(byte[] body) {
        this(BinaryData.fromBytes((byte[])Objects.requireNonNull(body, "'body' cannot be null.")));
    }

    public EventData(ByteBuffer body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").array());
    }

    public EventData(String body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").getBytes(StandardCharsets.UTF_8));
    }

    public EventData(BinaryData body) {
        this(body, new SystemProperties(), Context.NONE);
    }

    EventData(BinaryData body, SystemProperties systemProperties, Context context) {
        this.body = Objects.requireNonNull(body, "'body' cannot be null.");
        this.context = Objects.requireNonNull(context, "'context' cannot be null.");
        this.systemProperties = Objects.requireNonNull(systemProperties, "'systemProperties' cannot be null.");
        this.properties = new HashMap<String, Object>();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public byte[] getBody() {
        return this.body.toBytes();
    }

    public String getBodyAsString() {
        return new String(this.body.toBytes(), StandardCharsets.UTF_8);
    }

    public BinaryData getBodyAsBinaryData() {
        return this.body;
    }

    public Long getOffset() {
        return this.systemProperties.getOffset();
    }

    public String getPartitionKey() {
        return this.systemProperties.getPartitionKey();
    }

    public Instant getEnqueuedTime() {
        return this.systemProperties.getEnqueuedTime();
    }

    public Long getSequenceNumber() {
        return this.systemProperties.getSequenceNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventData eventData = (EventData)o;
        return Arrays.equals(this.body.toBytes(), eventData.body.toBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.body.toBytes());
    }

    Context getContext() {
        return this.context;
    }

    public EventData addContext(String key, Object value) {
        Objects.requireNonNull(key, "The 'key' parameter cannot be null.");
        Objects.requireNonNull(value, "The 'value' parameter cannot be null.");
        this.context = this.context.addData((Object)key, value);
        return this;
    }

    static {
        HashSet<String> properties = new HashSet<String>();
        properties.add(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.PUBLISHER_ANNOTATION_NAME.getValue());
        RESERVED_SYSTEM_PROPERTIES = Collections.unmodifiableSet(properties);
    }

    static class SystemProperties
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -2827050124966993723L;
        private final Long offset;
        private final String partitionKey;
        private final Instant enqueuedTime;
        private final Long sequenceNumber;

        SystemProperties() {
            this.offset = null;
            this.partitionKey = null;
            this.enqueuedTime = null;
            this.sequenceNumber = null;
        }

        SystemProperties(Map<String, Object> map) {
            super(map);
            this.partitionKey = (String)this.removeSystemProperty(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
            String offset = (String)this.removeSystemProperty(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue());
            if (offset == null) {
                throw new IllegalStateException(String.format(Locale.US, "offset: %s should always be in map.", AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue()));
            }
            this.offset = Long.valueOf(offset);
            this.put(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue(), this.offset);
            Date enqueuedTimeValue = (Date)this.removeSystemProperty(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
            if (enqueuedTimeValue == null) {
                throw new IllegalStateException(String.format(Locale.US, "enqueuedTime: %s should always be in map.", AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue()));
            }
            this.enqueuedTime = enqueuedTimeValue.toInstant();
            this.put(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue(), this.enqueuedTime);
            Long sequenceNumber = (Long)this.removeSystemProperty(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
            if (sequenceNumber == null) {
                throw new IllegalStateException(String.format(Locale.US, "sequenceNumber: %s should always be in map.", AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue()));
            }
            this.sequenceNumber = sequenceNumber;
            this.put(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue(), this.sequenceNumber);
        }

        private Long getOffset() {
            return this.offset;
        }

        private String getPartitionKey() {
            return this.partitionKey;
        }

        private Instant getEnqueuedTime() {
            return this.enqueuedTime;
        }

        private Long getSequenceNumber() {
            return this.sequenceNumber;
        }

        private <T> T removeSystemProperty(String key) {
            if (this.containsKey(key)) {
                return (T)this.remove(key);
            }
            return null;
        }
    }
}

