/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.models;

import java.time.Instant;
import java.util.Locale;
import java.util.Objects;

public final class EventPosition {
    private static final Long START_OF_STREAM = -1L;
    private static final String END_OF_STREAM = "@latest";
    private static final EventPosition EARLIEST = EventPosition.fromOffset(START_OF_STREAM, false);
    private static final EventPosition LATEST = new EventPosition(false, "@latest", null, null);
    private final boolean isInclusive;
    private final String offset;
    private final Long sequenceNumber;
    private final Instant enqueuedDateTime;

    private EventPosition(boolean isInclusive, String offset, Long sequenceNumber, Instant enqueuedDateTime) {
        this.offset = offset;
        this.sequenceNumber = sequenceNumber;
        this.enqueuedDateTime = enqueuedDateTime;
        this.isInclusive = isInclusive;
    }

    public static EventPosition earliest() {
        return EARLIEST;
    }

    public static EventPosition latest() {
        return LATEST;
    }

    public static EventPosition fromEnqueuedTime(Instant enqueuedDateTime) {
        return new EventPosition(false, null, null, enqueuedDateTime);
    }

    @Deprecated
    public static EventPosition fromOffset(long offset) {
        return EventPosition.fromOffset(offset, false);
    }

    @Deprecated
    private static EventPosition fromOffset(long offset, boolean isInclusive) {
        return new EventPosition(isInclusive, String.valueOf(offset), null, null);
    }

    public static EventPosition fromOffsetString(String offset) {
        return EventPosition.fromOffsetString(offset, false);
    }

    private static EventPosition fromOffsetString(String offset, boolean isInclusive) {
        return new EventPosition(isInclusive, offset, null, null);
    }

    public static EventPosition fromSequenceNumber(long sequenceNumber) {
        return EventPosition.fromSequenceNumber(sequenceNumber, false);
    }

    public static EventPosition fromSequenceNumber(long sequenceNumber, boolean isInclusive) {
        return new EventPosition(isInclusive, null, sequenceNumber, null);
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    public String getOffset() {
        return this.offset;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant getEnqueuedDateTime() {
        return this.enqueuedDateTime;
    }

    public String toString() {
        return String.format(Locale.US, "offset[%s], sequenceNumber[%s], enqueuedTime[%s], isInclusive[%s]", this.offset, this.sequenceNumber, this.enqueuedDateTime != null ? Long.valueOf(this.enqueuedDateTime.toEpochMilli()) : "null", this.isInclusive);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EventPosition)) {
            return false;
        }
        EventPosition other = (EventPosition)obj;
        return Objects.equals(this.isInclusive, other.isInclusive) && Objects.equals(this.offset, other.offset) && Objects.equals(this.sequenceNumber, other.sequenceNumber) && Objects.equals(this.enqueuedDateTime, other.enqueuedDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.isInclusive, this.offset, this.sequenceNumber, this.enqueuedDateTime);
    }
}

