/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.AmqpConstants;
import com.azure.core.amqp.implementation.AmqpSendLink;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.ConnectionCacheWrapper;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.EventHubsProducerInstrumentation;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import com.azure.messaging.eventhubs.implementation.instrumentation.OperationName;
import com.azure.messaging.eventhubs.models.CreateBatchOptions;
import com.azure.messaging.eventhubs.models.SendOptions;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

@ServiceClient(builder=EventHubClientBuilder.class, isAsync=true)
public class EventHubProducerAsyncClient
implements Closeable {
    private static final int MAX_PARTITION_KEY_LENGTH = 128;
    private static final String SENDER_ENTITY_PATH_FORMAT = "%s/Partitions/%s";
    private static final SendOptions DEFAULT_SEND_OPTIONS = new SendOptions();
    private static final CreateBatchOptions DEFAULT_BATCH_OPTIONS = new CreateBatchOptions();
    private static final ClientLogger LOGGER = new ClientLogger(EventHubProducerAsyncClient.class);
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final String fullyQualifiedNamespace;
    private final String eventHubName;
    private final ConnectionCacheWrapper connectionProcessor;
    private final AmqpRetryOptions retryOptions;
    private final EventHubsProducerInstrumentation instrumentation;
    private final MessageSerializer messageSerializer;
    private final Scheduler scheduler;
    private final boolean isSharedConnection;
    private final Runnable onClientClose;
    private final String identifier;

    EventHubProducerAsyncClient(String fullyQualifiedNamespace, String eventHubName, ConnectionCacheWrapper connectionProcessor, AmqpRetryOptions retryOptions, MessageSerializer messageSerializer, Scheduler scheduler, boolean isSharedConnection, Runnable onClientClose, String identifier, EventHubsProducerInstrumentation instrumentation) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.scheduler = scheduler;
        this.isSharedConnection = isSharedConnection;
        this.identifier = identifier;
        this.instrumentation = Objects.requireNonNull(instrumentation, "'instrumentation' cannot be null.");
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EventHubProperties> getEventHubProperties() {
        return this.instrumentation.instrumentMono(this.connectionProcessor.getManagementNodeWithRetries().flatMap(EventHubManagementNode::getEventHubProperties), OperationName.GET_EVENT_HUB_PROPERTIES, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<String> getPartitionIds() {
        return this.getEventHubProperties().flatMapMany(properties -> Flux.fromIterable(properties.getPartitionIds()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PartitionProperties> getPartitionProperties(String partitionId) {
        return this.instrumentation.instrumentMono(this.connectionProcessor.getManagementNodeWithRetries().flatMap(node -> node.getPartitionProperties(partitionId)), OperationName.GET_PARTITION_PROPERTIES, partitionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EventDataBatch> createBatch() {
        return this.createBatch(DEFAULT_BATCH_OPTIONS);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EventDataBatch> createBatch(CreateBatchOptions options) {
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        String partitionKey = options.getPartitionKey();
        String partitionId = options.getPartitionId();
        int batchMaxSize = options.getMaximumSizeInBytes();
        if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey) && !CoreUtils.isNullOrEmpty((CharSequence)partitionId)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "CreateBatchOptions.getPartitionKey() and CreateBatchOptions.getPartitionId() are both set. Only one or the other can be used. partitionKey: '%s'. partitionId: '%s'", partitionKey, partitionId)));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey) && partitionKey.length() > 128) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "Partition key '%s' exceeds the maximum allowed length: '%s'.", partitionKey, 128)));
        }
        Mono createBatch = this.getSendLink(partitionId).flatMap(link -> link.getLinkSize().flatMap(size -> {
            int maximumLinkSize;
            int n = maximumLinkSize = size > 0 ? size : 262144;
            if (batchMaxSize > maximumLinkSize) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "BatchOptions.maximumSizeInBytes (%s bytes) is larger than the link size (%s bytes).", batchMaxSize, maximumLinkSize)));
            }
            int batchSize = batchMaxSize > 0 ? batchMaxSize : maximumLinkSize;
            return Mono.just((Object)new EventDataBatch(batchSize, partitionId, partitionKey, () -> ((AmqpSendLink)link).getErrorContext(), this.instrumentation));
        }));
        return RetryUtil.withRetry((Mono)createBatch, (AmqpRetryOptions)this.retryOptions, (String)String.format("partitionId[%s]: Creating batch timed out.", partitionId)).publishOn(this.scheduler);
    }

    Mono<Void> send(EventData event) {
        if (event == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'event' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.just((Object)((Object)event)));
    }

    Mono<Void> send(EventData event, SendOptions options) {
        if (event == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'event' cannot be null."));
        }
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.just((Object)((Object)event)), options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> send(Iterable<EventData> events) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.fromIterable(events));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> send(Iterable<EventData> events, SendOptions options) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.fromIterable(events), options);
    }

    Mono<Void> send(Flux<EventData> events) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        return this.send(events, DEFAULT_SEND_OPTIONS);
    }

    Mono<Void> send(Flux<EventData> events, SendOptions options) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.sendInternal(events, options).publishOn(this.scheduler);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> send(EventDataBatch batch) {
        if (batch == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'batch' cannot be null."));
        }
        if (batch.getEvents().isEmpty()) {
            LOGGER.warning(Messages.CANNOT_SEND_EVENT_BATCH_EMPTY);
            return Mono.empty();
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)batch.getPartitionId())) {
            LOGGER.atVerbose().addKeyValue("size", (long)batch.getCount()).addKeyValue("partitionId", batch.getPartitionId()).log("Sending batch.");
        } else if (!CoreUtils.isNullOrEmpty((CharSequence)batch.getPartitionKey())) {
            LOGGER.atVerbose().addKeyValue("size", (long)batch.getCount()).addKeyValue("partitionKey", batch.getPartitionKey()).log("Sending batch.");
        } else {
            LOGGER.atVerbose().addKeyValue("size", (long)batch.getCount()).log("Sending batch to be distributed round-robin in service.");
        }
        String partitionKey = batch.getPartitionKey();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < batch.getEvents().size(); ++i) {
            EventData event = batch.getEvents().get(i);
            Message message = this.messageSerializer.serialize((Object)event);
            if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey)) {
                MessageAnnotations messageAnnotations = message.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : message.getMessageAnnotations();
                messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
                message.setMessageAnnotations(messageAnnotations);
            }
            messages.add(message);
        }
        Mono sendMessage = this.getSendLink(batch.getPartitionId()).flatMap(link -> messages.size() == 1 ? link.send((Message)messages.get(0)) : link.send(messages));
        Mono send = RetryUtil.withRetry((Mono)sendMessage, (AmqpRetryOptions)this.retryOptions, (String)String.format("partitionId[%s]: Sending messages timed out.", batch.getPartitionId())).publishOn(this.scheduler);
        return this.instrumentation.sendBatch(send, batch);
    }

    private Mono<Void> sendInternal(Flux<EventData> events, SendOptions options) {
        String partitionKey = options.getPartitionKey();
        String partitionId = options.getPartitionId();
        if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey) && !CoreUtils.isNullOrEmpty((CharSequence)partitionId)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "SendOptions.getPartitionKey() and SendOptions.getPartitionId() are both set. Only one or the other can be used. partitionKey: '%s'. partitionId: '%s'", partitionKey, partitionId)));
        }
        return this.getSendLink(options.getPartitionId()).flatMap(link -> link.getLinkSize().flatMap(size -> {
            int batchSize = size > 0 ? size : 262144;
            CreateBatchOptions batchOptions = new CreateBatchOptions().setPartitionKey(options.getPartitionKey()).setPartitionId(options.getPartitionId()).setMaximumSizeInBytes(batchSize);
            return events.collect((Collector)new EventDataCollector(batchOptions, 1, () -> ((AmqpSendLink)link).getErrorContext(), this.instrumentation));
        }).flatMap(list -> this.sendInternal((Flux<EventDataBatch>)Flux.fromIterable((Iterable)list))));
    }

    private Mono<Void> sendInternal(Flux<EventDataBatch> eventBatches) {
        return eventBatches.flatMap(this::send).then().doOnError(error -> LOGGER.error(Messages.ERROR_SENDING_BATCH, new Object[]{error}));
    }

    private String getEntityPath(String partitionId) {
        return CoreUtils.isNullOrEmpty((CharSequence)partitionId) ? this.eventHubName : String.format(Locale.US, SENDER_ENTITY_PATH_FORMAT, this.eventHubName, partitionId);
    }

    private Mono<AmqpSendLink> getSendLink(String partitionId) {
        String entityPath;
        String linkName = entityPath = this.getEntityPath(partitionId);
        return this.connectionProcessor.getConnection().flatMap(connection -> connection.createSendLink(linkName, entityPath, this.retryOptions, this.identifier));
    }

    @Override
    public void close() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        if (this.isSharedConnection) {
            this.onClientClose.run();
        } else {
            this.connectionProcessor.dispose();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private static class EventDataCollector
    implements Collector<EventData, List<EventDataBatch>, List<EventDataBatch>> {
        private final String partitionKey;
        private final String partitionId;
        private final int maxMessageSize;
        private final Integer maxNumberOfBatches;
        private final ErrorContextProvider contextProvider;
        private final EventHubsProducerInstrumentation instrumentation;
        private volatile EventDataBatch currentBatch;

        EventDataCollector(CreateBatchOptions options, Integer maxNumberOfBatches, ErrorContextProvider contextProvider, EventHubsProducerInstrumentation instrumentation) {
            this.maxNumberOfBatches = maxNumberOfBatches;
            this.maxMessageSize = options.getMaximumSizeInBytes() > 0 ? options.getMaximumSizeInBytes() : 262144;
            this.partitionKey = options.getPartitionKey();
            this.partitionId = options.getPartitionId();
            this.contextProvider = contextProvider;
            this.instrumentation = instrumentation;
            this.currentBatch = new EventDataBatch(this.maxMessageSize, this.partitionId, this.partitionKey, contextProvider, instrumentation);
        }

        @Override
        public Supplier<List<EventDataBatch>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<EventDataBatch>, EventData> accumulator() {
            return (list, event) -> {
                EventDataBatch batch = this.currentBatch;
                if (batch.tryAdd((EventData)((Object)event))) {
                    return;
                }
                if (this.maxNumberOfBatches != null && list.size() == this.maxNumberOfBatches.intValue()) {
                    String message = String.format(Locale.US, Messages.EVENT_DATA_DOES_NOT_FIT, this.maxNumberOfBatches);
                    throw new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, message, this.contextProvider.getErrorContext());
                }
                this.currentBatch = new EventDataBatch(this.maxMessageSize, this.partitionId, this.partitionKey, this.contextProvider, this.instrumentation);
                this.currentBatch.tryAdd((EventData)((Object)event));
                list.add(batch);
            };
        }

        @Override
        public BinaryOperator<List<EventDataBatch>> combiner() {
            return (existing, another) -> {
                existing.addAll(another);
                return existing;
            };
        }

        @Override
        public Function<List<EventDataBatch>, List<EventDataBatch>> finisher() {
            return list -> {
                EventDataBatch batch = this.currentBatch;
                this.currentBatch = null;
                if (batch != null) {
                    list.add(batch);
                }
                return list;
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

