/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.models;

import com.azure.core.amqp.implementation.ConnectionStringProperties;
import java.net.URI;

public final class EventHubConnectionStringProperties {
    private final URI endpoint;
    private final String entityPath;
    private final String sharedAccessKeyName;
    private final String sharedAccessKey;

    private EventHubConnectionStringProperties(ConnectionStringProperties properties) {
        this.endpoint = properties.getEndpoint();
        this.entityPath = properties.getEntityPath();
        this.sharedAccessKeyName = properties.getSharedAccessKeyName();
        this.sharedAccessKey = properties.getSharedAccessKey();
    }

    public static EventHubConnectionStringProperties parse(String connectionString) {
        return new EventHubConnectionStringProperties(new ConnectionStringProperties(connectionString));
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getEndpoint() {
        return String.format("%s://%s", this.endpoint.getScheme(), this.endpoint.getHost());
    }

    public String getFullyQualifiedNamespace() {
        return this.endpoint.getHost();
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }
}

