/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsMetricsProvider;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsTracer;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class EventHubsProducerInstrumentation {
    private final EventHubsTracer tracer;
    private final EventHubsMetricsProvider meter;

    EventHubsProducerInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityName) {
        this.tracer = new EventHubsTracer(tracer, fullyQualifiedName, entityName);
        this.meter = new EventHubsMetricsProvider(meter, fullyQualifiedName, entityName, null);
    }

    <T> Mono<T> onSendBatch(Mono<T> publisher, EventDataBatch batch, String spanName) {
        if (!this.tracer.isEnabled() && !this.meter.isSendCountEnabled()) {
            return publisher;
        }
        if (this.tracer.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    Context span = (Context)signal.getContextView().getOrDefault((Object)"otel-context-key", (Object)Context.NONE);
                    this.meter.reportBatchSend(batch.getCount(), batch.getPartitionId(), signal.getThrowable(), span);
                    this.tracer.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)reactor.util.context.Context.of((Object)"otel-context-key", (Object)this.startPublishSpanWithLinks(spanName, batch, Context.NONE)));
        }
        return publisher.doOnEach(signal -> {
            if (signal.isOnComplete() || signal.isOnError()) {
                this.meter.reportBatchSend(batch.getCount(), batch.getPartitionId(), signal.getThrowable(), Context.NONE);
            }
        });
    }

    public EventHubsTracer getTracer() {
        return this.tracer;
    }

    private Context startPublishSpanWithLinks(String spanName, EventDataBatch batch, Context context) {
        StartSpanOptions startOptions = this.tracer.createStartOption(SpanKind.CLIENT, EventHubsTracer.OperationName.PUBLISH);
        if (batch != null) {
            startOptions.setAttribute("messaging.batch.message_count", (Object)batch.getCount());
            for (EventData event : batch.getEvents()) {
                startOptions.addLink(this.tracer.createLink(event.getProperties(), null, event.getContext()));
            }
        }
        return this.tracer.startSpan(spanName, startOptions, context);
    }
}

