/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.IterableStream;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubBufferedProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubBufferedProducerClientBuilder;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.models.SendOptions;
import java.io.Closeable;
import java.time.Duration;

@ServiceClient(builder=EventHubBufferedProducerClientBuilder.class, isAsync=false)
public final class EventHubBufferedProducerClient
implements Closeable {
    private final EventHubBufferedProducerAsyncClient client;
    private final Duration operationTimeout;

    EventHubBufferedProducerClient(EventHubBufferedProducerAsyncClient asyncClient, Duration operationTimeout) {
        this.client = asyncClient;
        this.operationTimeout = operationTimeout;
    }

    public String getFullyQualifiedNamespace() {
        return this.client.getFullyQualifiedNamespace();
    }

    public String getEventHubName() {
        return this.client.getEventHubName();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventHubProperties getEventHubProperties() {
        return (EventHubProperties)this.client.getEventHubProperties().block(this.operationTimeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<String> getPartitionIds() {
        return new IterableStream(this.client.getPartitionIds());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PartitionProperties getPartitionProperties(String partitionId) {
        return (PartitionProperties)this.client.getPartitionProperties(partitionId).block(this.operationTimeout);
    }

    public int getBufferedEventCount() {
        return this.client.getBufferedEventCount();
    }

    public int getBufferedEventCount(String partitionId) {
        return this.client.getBufferedEventCount(partitionId);
    }

    public Integer enqueueEvent(EventData eventData) {
        return (Integer)this.client.enqueueEvent(eventData).block(this.operationTimeout);
    }

    public Integer enqueueEvent(EventData eventData, SendOptions options) {
        return (Integer)this.client.enqueueEvent(eventData, options).block(this.operationTimeout);
    }

    public Integer enqueueEvents(Iterable<EventData> events) {
        return (Integer)this.client.enqueueEvents(events).block(this.operationTimeout);
    }

    public Integer enqueueEvents(Iterable<EventData> events, SendOptions options) {
        return (Integer)this.client.enqueueEvents(events, options).block(this.operationTimeout);
    }

    public void flush() {
        this.client.flush().block(this.operationTimeout.plus(this.operationTimeout));
    }

    @Override
    public void close() {
        this.client.close();
    }
}

