/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.models;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.Checkpoint;
import com.azure.messaging.eventhubs.models.LastEnqueuedEventProperties;
import com.azure.messaging.eventhubs.models.PartitionContext;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class EventBatchContext {
    private final PartitionContext partitionContext;
    private final List<EventData> events;
    private final CheckpointStore checkpointStore;
    private final LastEnqueuedEventProperties lastEnqueuedEventProperties;

    public EventBatchContext(PartitionContext partitionContext, List<EventData> events, CheckpointStore checkpointStore, LastEnqueuedEventProperties lastEnqueuedEventProperties) {
        this.checkpointStore = Objects.requireNonNull(checkpointStore, "'checkpointStore' cannot be null.");
        this.events = Objects.requireNonNull(events, "'events' cannot be null.");
        this.partitionContext = Objects.requireNonNull(partitionContext, "'partitionContext' cannot be null.");
        this.lastEnqueuedEventProperties = lastEnqueuedEventProperties;
    }

    public PartitionContext getPartitionContext() {
        return this.partitionContext;
    }

    public List<EventData> getEvents() {
        return this.events;
    }

    public LastEnqueuedEventProperties getLastEnqueuedEventProperties() {
        return this.lastEnqueuedEventProperties;
    }

    public Mono<Void> updateCheckpointAsync() {
        if (this.events.isEmpty()) {
            return Mono.empty();
        }
        Checkpoint checkpoint = new Checkpoint().setFullyQualifiedNamespace(this.partitionContext.getFullyQualifiedNamespace()).setEventHubName(this.partitionContext.getEventHubName()).setConsumerGroup(this.partitionContext.getConsumerGroup()).setPartitionId(this.partitionContext.getPartitionId()).setSequenceNumber(this.events.get(this.events.size() - 1).getSequenceNumber()).setOffset(this.events.get(this.events.size() - 1).getOffset());
        return this.checkpointStore.updateCheckpoint(checkpoint);
    }

    public void updateCheckpoint() {
        this.updateCheckpointAsync().block();
    }
}

