/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.InitializationContext;

public abstract class PartitionProcessor {
    private final ClientLogger logger = new ClientLogger(PartitionProcessor.class);

    public void initialize(InitializationContext initializationContext) {
        this.logger.info("Initializing partition processor for partition {}", new Object[]{initializationContext.getPartitionContext().getPartitionId()});
    }

    public abstract void processEvent(EventContext var1);

    public abstract void processError(ErrorContext var1);

    public void close(CloseContext closeContext) {
        this.logger.info("Closing partition processor for partition {} with close reason {}", new Object[]{closeContext.getPartitionContext().getPartitionId(), closeContext.getCloseReason()});
    }
}

