/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.implementation.PartitionProcessor;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.messaging.eventhubs.models.InitializationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ServiceClientBuilder(serviceClients={EventProcessorClient.class})
public class EventProcessorClientBuilder {
    private final ClientLogger logger = new ClientLogger(EventProcessorClientBuilder.class);
    private final EventHubClientBuilder eventHubClientBuilder;
    private String consumerGroup;
    private CheckpointStore checkpointStore;
    private Consumer<EventContext> processEvent;
    private Consumer<ErrorContext> processError;
    private Consumer<InitializationContext> processPartitionInitialization;
    private Consumer<CloseContext> processPartitionClose;
    private boolean trackLastEnqueuedEventProperties;
    private Map<String, EventPosition> initialPartitionEventPosition = new HashMap<String, EventPosition>();

    public EventProcessorClientBuilder() {
        this.eventHubClientBuilder = new EventHubClientBuilder();
    }

    public EventProcessorClientBuilder connectionString(String connectionString) {
        this.eventHubClientBuilder.connectionString(connectionString);
        return this;
    }

    public EventProcessorClientBuilder connectionString(String connectionString, String eventHubName) {
        this.eventHubClientBuilder.connectionString(connectionString, eventHubName);
        return this;
    }

    public EventProcessorClientBuilder configuration(Configuration configuration) {
        this.eventHubClientBuilder.configuration(configuration);
        return this;
    }

    public EventProcessorClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, TokenCredential credential) {
        this.eventHubClientBuilder.credential(fullyQualifiedNamespace, eventHubName, credential);
        return this;
    }

    public EventProcessorClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.eventHubClientBuilder.proxyOptions(proxyOptions);
        return this;
    }

    public EventProcessorClientBuilder transportType(AmqpTransportType transport) {
        this.eventHubClientBuilder.transportType(transport);
        return this;
    }

    public EventProcessorClientBuilder retry(AmqpRetryOptions retryOptions) {
        this.eventHubClientBuilder.retry(retryOptions);
        return this;
    }

    public EventProcessorClientBuilder consumerGroup(String consumerGroup) {
        this.consumerGroup = Objects.requireNonNull(consumerGroup, "'consumerGroup' cannot be null");
        return this;
    }

    public EventProcessorClientBuilder checkpointStore(CheckpointStore checkpointStore) {
        this.checkpointStore = Objects.requireNonNull(checkpointStore, "'checkpointStore' cannot be null");
        return this;
    }

    public EventProcessorClientBuilder processEvent(Consumer<EventContext> processEvent) {
        this.processEvent = Objects.requireNonNull(processEvent, "'processEvent' cannot be null");
        return this;
    }

    public EventProcessorClientBuilder processError(Consumer<ErrorContext> processError) {
        this.processError = processError;
        return this;
    }

    public EventProcessorClientBuilder processPartitionInitialization(Consumer<InitializationContext> initializePartition) {
        this.processPartitionInitialization = initializePartition;
        return this;
    }

    public EventProcessorClientBuilder processPartitionClose(Consumer<CloseContext> closePartition) {
        this.processPartitionClose = closePartition;
        return this;
    }

    public EventProcessorClientBuilder trackLastEnqueuedEventProperties(boolean trackLastEnqueuedEventProperties) {
        this.trackLastEnqueuedEventProperties = trackLastEnqueuedEventProperties;
        return this;
    }

    public EventProcessorClientBuilder initialPartitionEventPosition(Map<String, EventPosition> initialPartitionEventPosition) {
        this.initialPartitionEventPosition = Objects.requireNonNull(initialPartitionEventPosition, "'initialPartitionEventPosition' cannot be null.");
        return this;
    }

    public EventProcessorClient buildEventProcessorClient() {
        Objects.requireNonNull(this.processEvent, "'processEvent' cannot be null");
        Objects.requireNonNull(this.processError, "'processError' cannot be null");
        Objects.requireNonNull(this.checkpointStore, "'checkpointStore' cannot be null");
        Objects.requireNonNull(this.consumerGroup, "'consumerGroup' cannot be null");
        TracerProvider tracerProvider = new TracerProvider(ServiceLoader.load(Tracer.class));
        return new EventProcessorClient(this.eventHubClientBuilder, this.consumerGroup, this.getPartitionProcessorSupplier(), this.checkpointStore, this.trackLastEnqueuedEventProperties, tracerProvider, this.processError, this.initialPartitionEventPosition);
    }

    private Supplier<PartitionProcessor> getPartitionProcessorSupplier() {
        return () -> new PartitionProcessor(){

            @Override
            public void processEvent(EventContext eventContext) {
                EventProcessorClientBuilder.this.processEvent.accept(eventContext);
            }

            @Override
            public void initialize(InitializationContext initializationContext) {
                if (EventProcessorClientBuilder.this.processPartitionInitialization != null) {
                    EventProcessorClientBuilder.this.processPartitionInitialization.accept(initializationContext);
                } else {
                    super.initialize(initializationContext);
                }
            }

            @Override
            public void processError(ErrorContext errorContext) {
                EventProcessorClientBuilder.this.processError.accept(errorContext);
            }

            @Override
            public void close(CloseContext closeContext) {
                if (EventProcessorClientBuilder.this.processPartitionClose != null) {
                    EventProcessorClientBuilder.this.processPartitionClose.accept(closeContext);
                } else {
                    super.close(closeContext);
                }
            }
        };
    }
}

