/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.CbsAuthorizationType;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventHubAsyncClient;
import com.azure.messaging.eventhubs.EventHubClient;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventHubMessageSerializer;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.messaging.eventhubs.implementation.ClientConstants;
import com.azure.messaging.eventhubs.implementation.EventHubAmqpConnection;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubReactorAmqpConnection;
import com.azure.messaging.eventhubs.implementation.EventHubSharedKeyCredential;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@ServiceClientBuilder(serviceClients={EventHubProducerAsyncClient.class, EventHubProducerClient.class, EventHubConsumerAsyncClient.class, EventHubConsumerClient.class})
public class EventHubClientBuilder {
    public static final String DEFAULT_CONSUMER_GROUP_NAME = "$Default";
    private static final int MINIMUM_PREFETCH_COUNT = 1;
    private static final int MAXIMUM_PREFETCH_COUNT = 8000;
    static final int DEFAULT_PREFETCH_COUNT = 500;
    private static final String EVENTHUBS_PROPERTIES_FILE = "azure-messaging-eventhubs.properties";
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String UNKNOWN = "UNKNOWN";
    private final ClientLogger logger = new ClientLogger(EventHubClientBuilder.class);
    private static final String AZURE_EVENT_HUBS_CONNECTION_STRING = "AZURE_EVENT_HUBS_CONNECTION_STRING";
    private static final AmqpRetryOptions DEFAULT_RETRY = new AmqpRetryOptions().setTryTimeout(ClientConstants.OPERATION_TIMEOUT);
    private TokenCredential credentials;
    private Configuration configuration;
    private ProxyOptions proxyOptions;
    private AmqpRetryOptions retryOptions;
    private Scheduler scheduler;
    private AmqpTransportType transport = AmqpTransportType.AMQP;
    private String fullyQualifiedNamespace;
    private String eventHubName;
    private String consumerGroup;
    private EventHubConnectionProcessor eventHubConnectionProcessor;
    private int prefetchCount = 500;
    private boolean isSharedConnection = false;

    public EventHubClientBuilder connectionString(String connectionString) {
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        EventHubSharedKeyCredential tokenCredential = new EventHubSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ClientConstants.TOKEN_VALIDITY);
        return this.credential(properties.getEndpoint().getHost(), properties.getEntityPath(), tokenCredential);
    }

    public EventHubClientBuilder connectionString(String connectionString, String eventHubName) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (connectionString.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot be an empty string."));
        }
        if (eventHubName.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        EventHubSharedKeyCredential tokenCredential = new EventHubSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ClientConstants.TOKEN_VALIDITY);
        if (!CoreUtils.isNullOrEmpty((CharSequence)properties.getEntityPath()) && !eventHubName.equals(properties.getEntityPath())) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "'connectionString' contains an Event Hub name [%s] and it does not match the given 'eventHubName' parameter [%s]. Please use the credentials(String connectionString) overload. Or supply a 'connectionString' without 'EntityPath' in it.", properties.getEntityPath(), eventHubName)));
        }
        return this.credential(properties.getEndpoint().getHost(), eventHubName, tokenCredential);
    }

    public EventHubClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public EventHubClientBuilder shareConnection() {
        this.isSharedConnection = true;
        return this;
    }

    public EventHubClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, TokenCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'host' cannot be an empty string."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)eventHubName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        return this;
    }

    public EventHubClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public EventHubClientBuilder transportType(AmqpTransportType transport) {
        this.transport = transport;
        return this;
    }

    public EventHubClientBuilder retry(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public EventHubClientBuilder consumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public EventHubClientBuilder prefetchCount(int prefetchCount) {
        if (prefetchCount < 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "PrefetchCount, '%s' has to be above %s", prefetchCount, 1)));
        }
        if (prefetchCount > 8000) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "PrefetchCount, '%s', has to be below %s", prefetchCount, 8000)));
        }
        this.prefetchCount = prefetchCount;
        return this;
    }

    EventHubClientBuilder scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public EventHubConsumerAsyncClient buildAsyncConsumerClient() {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.consumerGroup)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'consumerGroup' cannot be null or an empty string. using EventHubClientBuilder.consumerGroup(String)"));
        }
        return this.buildAsyncClient().createConsumer(this.consumerGroup, this.prefetchCount);
    }

    public EventHubConsumerClient buildConsumerClient() {
        return this.buildClient().createConsumer(this.consumerGroup, this.prefetchCount);
    }

    public EventHubProducerAsyncClient buildAsyncProducerClient() {
        return this.buildAsyncClient().createProducer();
    }

    public EventHubProducerClient buildProducerClient() {
        return this.buildClient().createProducer();
    }

    EventHubAsyncClient buildAsyncClient() {
        if (this.retryOptions == null) {
            this.retryOptions = DEFAULT_RETRY;
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.elastic();
        }
        EventHubMessageSerializer messageSerializer = new EventHubMessageSerializer();
        if (this.isSharedConnection && this.eventHubConnectionProcessor == null) {
            this.eventHubConnectionProcessor = this.buildConnectionProcessor(messageSerializer);
        }
        EventHubConnectionProcessor processor = this.isSharedConnection ? this.eventHubConnectionProcessor : this.buildConnectionProcessor(messageSerializer);
        TracerProvider tracerProvider = new TracerProvider(ServiceLoader.load(Tracer.class));
        return new EventHubAsyncClient(processor, tracerProvider, messageSerializer, this.scheduler, this.isSharedConnection);
    }

    EventHubClient buildClient() {
        EventHubAsyncClient client = this.buildAsyncClient();
        return new EventHubClient(client, this.retryOptions);
    }

    private EventHubConnectionProcessor buildConnectionProcessor(MessageSerializer messageSerializer) {
        ConnectionOptions connectionOptions = this.getConnectionOptions();
        AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), "https://eventhubs.azure.net/.default");
        ReactorProvider provider = new ReactorProvider();
        ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider);
        Map properties = CoreUtils.getProperties((String)EVENTHUBS_PROPERTIES_FILE);
        String product = properties.getOrDefault(NAME_KEY, UNKNOWN);
        String clientVersion = properties.getOrDefault(VERSION_KEY, UNKNOWN);
        Flux connectionFlux = Mono.fromCallable(() -> EventHubClientBuilder.lambda$buildConnectionProcessor$0(connectionOptions, provider, handlerProvider, (TokenManagerProvider)tokenManagerProvider, messageSerializer, product, clientVersion)).repeat();
        return (EventHubConnectionProcessor)connectionFlux.subscribeWith((Subscriber)new EventHubConnectionProcessor(connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getEntityPath(), connectionOptions.getRetry()));
    }

    private ConnectionOptions getConnectionOptions() {
        Configuration configuration = this.configuration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        if (this.credentials == null) {
            String connectionString = this.configuration.get(AZURE_EVENT_HUBS_CONNECTION_STRING);
            if (CoreUtils.isNullOrEmpty((CharSequence)connectionString)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credentials have not been set. They can be set using: connectionString(String), connectionString(String, String), credentials(String, String, TokenCredential), or setting the environment variable 'AZURE_EVENT_HUBS_CONNECTION_STRING' with a connection string"));
            }
            this.connectionString(connectionString);
        }
        if (this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured() && this.transport != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot use a proxy when TransportType is not AMQP."));
        }
        if (this.proxyOptions == null) {
            this.proxyOptions = this.getDefaultProxyConfiguration(this.configuration);
        }
        CbsAuthorizationType authorizationType = this.credentials instanceof EventHubSharedKeyCredential ? CbsAuthorizationType.SHARED_ACCESS_SIGNATURE : CbsAuthorizationType.JSON_WEB_TOKEN;
        return new ConnectionOptions(this.fullyQualifiedNamespace, this.eventHubName, this.credentials, authorizationType, this.transport, this.retryOptions, this.proxyOptions, this.scheduler);
    }

    private ProxyOptions getDefaultProxyConfiguration(Configuration configuration) {
        String proxyAddress;
        ProxyAuthenticationType authentication = ProxyAuthenticationType.NONE;
        if (this.proxyOptions != null) {
            authentication = this.proxyOptions.getAuthentication();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)(proxyAddress = configuration.get("HTTP_PROXY")))) {
            return ProxyOptions.SYSTEM_DEFAULTS;
        }
        String[] hostPort = proxyAddress.split(":");
        if (hostPort.length < 2) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("HTTP_PROXY cannot be parsed into a proxy"));
        }
        String host = hostPort[0];
        int port = Integer.parseInt(hostPort[1]);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        String username = configuration.get("PROXY_USERNAME");
        String password = configuration.get("PROXY_PASSWORD");
        return new ProxyOptions(authentication, proxy, username, password);
    }

    private static /* synthetic */ EventHubAmqpConnection lambda$buildConnectionProcessor$0(ConnectionOptions connectionOptions, ReactorProvider provider, ReactorHandlerProvider handlerProvider, TokenManagerProvider tokenManagerProvider, MessageSerializer messageSerializer, String product, String clientVersion) throws Exception {
        String connectionId = StringUtil.getRandomString((String)"MF");
        return new EventHubReactorAmqpConnection(connectionId, connectionOptions, provider, handlerProvider, tokenManagerProvider, messageSerializer, product, clientVersion);
    }
}

