/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public final class AcsChatParticipantRemovedFromThreadEventData
extends AcsChatEventInThreadBaseProperties {
    private OffsetDateTime time;
    private CommunicationIdentifierModel removedByCommunicationIdentifier;
    private AcsChatThreadParticipantProperties participantRemoved;
    private Long version;

    public OffsetDateTime getTime() {
        return this.time;
    }

    public AcsChatParticipantRemovedFromThreadEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public CommunicationIdentifierModel getRemovedByCommunicationIdentifier() {
        return this.removedByCommunicationIdentifier;
    }

    public AcsChatParticipantRemovedFromThreadEventData setRemovedByCommunicationIdentifier(CommunicationIdentifierModel removedByCommunicationIdentifier) {
        this.removedByCommunicationIdentifier = removedByCommunicationIdentifier;
        return this;
    }

    public AcsChatThreadParticipantProperties getParticipantRemoved() {
        return this.participantRemoved;
    }

    public AcsChatParticipantRemovedFromThreadEventData setParticipantRemoved(AcsChatThreadParticipantProperties participantRemoved) {
        this.participantRemoved = participantRemoved;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AcsChatParticipantRemovedFromThreadEventData setVersion(Long version) {
        this.version = version;
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeJsonField("removedByCommunicationIdentifier", (JsonSerializable)this.removedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantRemoved", (JsonSerializable)this.participantRemoved);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeNumberField("version", (Number)this.version);
        return jsonWriter.writeEndObject();
    }

    public static AcsChatParticipantRemovedFromThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatParticipantRemovedFromThreadEventData)jsonReader.readObject(reader -> {
            AcsChatParticipantRemovedFromThreadEventData deserializedAcsChatParticipantRemovedFromThreadEventData = new AcsChatParticipantRemovedFromThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("removedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.removedByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("participantRemoved".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.participantRemoved = AcsChatThreadParticipantProperties.fromJson(reader);
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatParticipantRemovedFromThreadEventData;
        });
    }
}

