/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation.jackson.core;

import com.azure.json.implementation.jackson.core.Base64Variant;
import com.azure.json.implementation.jackson.core.Base64Variants;
import com.azure.json.implementation.jackson.core.JsonGenerationException;
import com.azure.json.implementation.jackson.core.JsonStreamContext;
import com.azure.json.implementation.jackson.core.io.CharTypes;
import com.azure.json.implementation.jackson.core.io.IOContext;
import com.azure.json.implementation.jackson.core.json.JsonWriteContext;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public abstract class JsonGenerator
implements Closeable,
Flushable {
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    public static final int SURR1_FIRST = 55296;
    public static final int SURR1_LAST = 56319;
    public static final int SURR2_FIRST = 56320;
    public static final int SURR2_LAST = 57343;
    protected static final String WRITE_BINARY = "write a binary value";
    protected static final String WRITE_BOOLEAN = "write a boolean value";
    protected static final String WRITE_NULL = "write a null";
    protected static final String WRITE_NUMBER = "write a number";
    protected static final String WRITE_STRING = "write a string";
    protected int _features;
    protected JsonWriteContext _writeContext;
    protected boolean _closed;
    protected final IOContext _ioContext;

    protected JsonGenerator(IOContext ctxt, int features) {
        this._ioContext = ctxt;
        this._features = features;
        this._writeContext = JsonWriteContext.createRootContext();
    }

    public JsonStreamContext getOutputContext() {
        return this._writeContext;
    }

    public final JsonGenerator configure(Feature f, boolean state) {
        int mask = f.getMask();
        this._features = state ? (this._features |= mask) : (this._features &= ~mask);
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._features & f.getMask()) != 0;
    }

    public abstract void writeStartArray() throws IOException;

    public abstract void writeEndArray() throws IOException;

    public abstract void writeStartObject() throws IOException;

    public abstract void writeEndObject() throws IOException;

    public abstract void writeFieldName(String var1) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    public abstract void writeRaw(String var1) throws IOException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException;

    public void writeRawValue(String text) throws IOException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(text);
    }

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException;

    public void writeBinary(byte[] data) throws IOException {
        this.writeBinary(Base64Variants.getDefaultVariant(), data, 0, data.length);
    }

    public abstract void writeNumber(int var1) throws IOException;

    public abstract void writeNumber(long var1) throws IOException;

    public abstract void writeNumber(double var1) throws IOException;

    public abstract void writeNumber(float var1) throws IOException;

    public abstract void writeBoolean(boolean var1) throws IOException;

    public abstract void writeNull() throws IOException;

    @Override
    public abstract void flush() throws IOException;

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    protected abstract void _releaseBuffers();

    protected abstract void _verifyValueWrite(String var1) throws IOException;

    protected void _reportError(String msg) throws JsonGenerationException {
        throw new JsonGenerationException(msg, this);
    }

    protected void _reportCantWriteValueExpectName(String typeMsg) throws IOException {
        this._reportError("Can not " + typeMsg + ", expecting field name (context: " + this._writeContext.typeDesc() + ")");
    }

    protected final int _decodeSurrogate(int surr1, int surr2) throws IOException {
        if (surr2 < 56320 || surr2 > 57343) {
            String msg = String.format("Incomplete surrogate pair: first char 0x%04X, second 0x%04X", surr1, surr2);
            this._reportError(msg);
        }
        return 65536 + (surr1 - 55296 << 10) + (surr2 - 56320);
    }

    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        FLUSH_PASSED_TO_STREAM(true),
        QUOTE_NON_NUMERIC_NUMBERS(true);

        private final boolean _defaultState;
        private final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

