/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.codesnippets;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.codesnippets.ComputerMemory;
import com.azure.json.codesnippets.ComputerProcessor;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class VmStatistics
implements JsonSerializable<VmStatistics> {
    private final String vmSize;
    private final ComputerProcessor processor;
    private final ComputerMemory memory;
    private final boolean acceleratedNetwork;
    private Map<String, Object> additionalProperties;

    public VmStatistics(String vmSize, ComputerProcessor processor, ComputerMemory memory, boolean acceleratedNetwork) {
        this.vmSize = vmSize;
        this.processor = processor;
        this.memory = memory;
        this.acceleratedNetwork = acceleratedNetwork;
    }

    public VmStatistics setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("VMSize", this.vmSize).writeJsonField("Processor", (JsonSerializable)this.processor).writeJsonField("Memory", (JsonSerializable)this.memory).writeBooleanField("AcceleratedNetwork", this.acceleratedNetwork);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static VmStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (VmStatistics)jsonReader.readObject(reader -> {
            String vmSize = null;
            boolean foundVmSize = false;
            ComputerProcessor processor = null;
            boolean foundProcessor = false;
            ComputerMemory memory = null;
            boolean foundMemory = false;
            boolean acceleratedNetwork = false;
            boolean foundAcceleratedNetwork = false;
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("VMSize".equalsIgnoreCase(fieldName)) {
                    vmSize = reader.getString();
                    foundVmSize = true;
                    continue;
                }
                if ("Processor".equalsIgnoreCase(fieldName)) {
                    processor = ComputerProcessor.fromJson(reader);
                    foundProcessor = true;
                    continue;
                }
                if ("Memory".equalsIgnoreCase(fieldName)) {
                    memory = ComputerMemory.fromJson(reader);
                    foundMemory = true;
                    continue;
                }
                if ("AcceleratedNetwork".equalsIgnoreCase(fieldName)) {
                    acceleratedNetwork = reader.getBoolean();
                    foundAcceleratedNetwork = true;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            if (foundVmSize && foundProcessor && foundMemory && foundAcceleratedNetwork) {
                return new VmStatistics(vmSize, processor, memory, acceleratedNetwork).setAdditionalProperties(additionalProperties);
            }
            throw new IOException("Missing one, or more, required fields. Required fields are 'VMSize', 'Processor','Memory', and 'AcceleratedNetwork'.");
        });
    }
}

