/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.codesnippets;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public class ComputerProcessor
implements JsonSerializable<ComputerProcessor> {
    private final int cores;
    private final int threads;
    private final String manufacturer;
    private final double clockSpeedInHertz;
    private final OffsetDateTime releaseDate;

    public ComputerProcessor(int cores, int threads, String manufacturer, double clockSpeedInHertz, OffsetDateTime releaseDate) {
        this.cores = cores;
        this.threads = threads;
        this.manufacturer = manufacturer;
        this.clockSpeedInHertz = clockSpeedInHertz;
        this.releaseDate = releaseDate;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeIntField("cores", this.cores).writeIntField("threads", this.threads).writeStringField("manufacturer", this.manufacturer).writeDoubleField("clockSpeedInHertz", this.clockSpeedInHertz).writeNullableField("releaseDate", (Object)this.releaseDate, (writer, value) -> writer.writeString(value.toString())).writeEndObject().flush();
    }

    public static ComputerProcessor fromJson(JsonReader jsonReader) throws IOException {
        return (ComputerProcessor)jsonReader.readObject(reader -> {
            int cores = 0;
            boolean foundCores = false;
            int threads = 0;
            boolean foundThreads = false;
            String manufacturer = null;
            boolean foundManufacturer = false;
            double clockSpeedInHertz = 0.0;
            boolean foundClockSpeedInHertz = false;
            OffsetDateTime releaseDate = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cores".equalsIgnoreCase(fieldName)) {
                    cores = reader.getInt();
                    foundCores = true;
                    continue;
                }
                if ("threads".equalsIgnoreCase(fieldName)) {
                    threads = reader.getInt();
                    foundThreads = true;
                    continue;
                }
                if ("manufacturer".equalsIgnoreCase(fieldName)) {
                    manufacturer = reader.getString();
                    foundManufacturer = true;
                    continue;
                }
                if ("clockSpeedInHertz".equalsIgnoreCase(fieldName)) {
                    clockSpeedInHertz = reader.getDouble();
                    foundClockSpeedInHertz = true;
                    continue;
                }
                if ("releaseDate".equalsIgnoreCase(fieldName)) {
                    releaseDate = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (foundCores && foundThreads && foundManufacturer && foundClockSpeedInHertz) {
                return new ComputerProcessor(cores, threads, manufacturer, clockSpeedInHertz, releaseDate);
            }
            throw new IOException("Missing one, or more, required fields. Required fields are 'cores', 'threads', 'manufacturer', and 'clockSpeedInHertz'.");
        });
    }
}

