/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.InteractiveBrowserCredential;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.Arrays;
import java.util.List;

public class InteractiveBrowserCredentialBuilder
extends AadCredentialBuilderBase<InteractiveBrowserCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(InteractiveBrowserCredentialBuilder.class);
    private Integer port;
    private boolean automaticAuthentication = true;
    private String redirectUrl;
    private String loginHint;

    @Deprecated
    public InteractiveBrowserCredentialBuilder port(int port) {
        this.port = port;
        return this;
    }

    InteractiveBrowserCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    InteractiveBrowserCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public InteractiveBrowserCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        this.identityClientOptions.setAuthenticationRecord(authenticationRecord);
        return this;
    }

    public InteractiveBrowserCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public InteractiveBrowserCredentialBuilder redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public InteractiveBrowserCredentialBuilder disableAutomaticAuthentication() {
        this.automaticAuthentication = false;
        return this;
    }

    public InteractiveBrowserCredentialBuilder loginHint(String loginHint) {
        this.loginHint = loginHint;
        return this;
    }

    @Override
    public InteractiveBrowserCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    @Override
    public InteractiveBrowserCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }

    public InteractiveBrowserCredential build() {
        ValidationUtil.validateInteractiveBrowserRedirectUrlSetup(this.port, this.redirectUrl, LOGGER);
        String clientId = this.clientId != null ? this.clientId : "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
        return new InteractiveBrowserCredential(clientId, this.tenantId, this.port, this.redirectUrl, this.automaticAuthentication, this.loginHint, this.identityClientOptions);
    }
}

