/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IntelliJAuthMethodDetails;
import com.azure.identity.implementation.IntelliJCacheAccessor;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class IntelliJCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJCredential.class);
    private static final String AZURE_TOOLS_FOR_INTELLIJ_CLIENT_ID = "61d65f5a-6e3b-468b-af73-a033f5098c5c";
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;

    IntelliJCredential(String tenantId, IdentityClientOptions identityClientOptions) {
        String tenant;
        IntelliJAuthMethodDetails authMethodDetails;
        IdentityClientOptions options = identityClientOptions == null ? new IdentityClientOptions() : identityClientOptions;
        IntelliJCacheAccessor accessor = new IntelliJCacheAccessor(options.getIntelliJKeePassDatabasePath());
        try {
            authMethodDetails = accessor.getAuthDetailsIfAvailable();
        }
        catch (Exception e) {
            authMethodDetails = null;
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)options.getAuthorityHost())) {
            String azureEnv = authMethodDetails != null ? authMethodDetails.getAzureEnv() : "";
            String cloudInstance = accessor.getAzureAuthHost(azureEnv);
            options.setAuthorityHost(cloudInstance);
        }
        if ((tenant = tenantId) == null) {
            tenant = "common";
        }
        this.identityClient = new IdentityClientBuilder().identityClientOptions(options).tenantId(tenant).clientId(AZURE_TOOLS_FOR_INTELLIJ_CLIENT_ID).build();
        this.cachedToken = new AtomicReference();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get().getAccount()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithIntelliJ(request))).map(msalToken -> {
            this.cachedToken.set((MsalToken)((Object)msalToken));
            return msalToken;
        }).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }
}

