/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;

public final class LoggingUtil {
    public static void logTokenSuccess(ClientLogger logger, TokenRequestContext context) {
        logger.info("Azure Identity => getToken() result for scopes [{}]: SUCCESS", new Object[]{String.join((CharSequence)", ", context.getScopes())});
    }

    public static void logTokenError(ClientLogger logger, TokenRequestContext context, Throwable error) {
        logger.error("Azure Identity => ERROR in getToken() call for scopes [{}]: {}", new Object[]{String.join((CharSequence)", ", context.getScopes()), error == null ? "" : error.getMessage()});
    }

    public static void logAvailableEnvironmentVariables(ClientLogger logger, Configuration configuration) {
        String msiEndpoint = configuration.get("MSI_ENDPOINT");
        String msiSecret = configuration.get("MSI_SECRET");
        String clientId = configuration.get("AZURE_CLIENT_ID");
        String tenantId = configuration.get("AZURE_TENANT_ID");
        String clientSecret = configuration.get("AZURE_CLIENT_SECRET");
        String certPath = configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
        String username = configuration.get("AZURE_USERNAME");
        String password = configuration.get("AZURE_PASSWORD");
        ArrayList<String> envVars = new ArrayList<String>();
        if (msiEndpoint != null) {
            envVars.add("MSI_ENDPOINT");
        }
        if (msiSecret != null) {
            envVars.add("MSI_SECRET");
        }
        if (clientId != null) {
            envVars.add("AZURE_CLIENT_ID");
        }
        if (tenantId != null) {
            envVars.add("AZURE_TENANT_ID");
        }
        if (clientSecret != null) {
            envVars.add("AZURE_CLIENT_SECRET");
        }
        if (certPath != null) {
            envVars.add("AZURE_CLIENT_CERTIFICATE_PATH");
        }
        if (username != null) {
            envVars.add("AZURE_USERNAME");
        }
        if (password != null) {
            envVars.add("AZURE_PASSWORD");
        }
        logger.verbose("Azure Identity => Found the following environment variables: {}", new Object[]{String.join((CharSequence)", ", envVars)});
    }

    private LoggingUtil() {
    }
}

