/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import reactor.core.publisher.Mono;

public class AzurePowerShellCredential
implements TokenCredential {
    private final IdentityClient identityClient;
    private final ClientLogger logger = new ClientLogger(AzurePowerShellCredential.class);

    AzurePowerShellCredential(IdentityClientOptions options) {
        this.identityClient = new IdentityClientBuilder().identityClientOptions(options).build();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithAzurePowerShell(request).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error));
    }
}

