/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.util.logging.ClientLogger;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class IdentitySslUtil {
    public static final HostnameVerifier ALL_HOSTS_ACCEPT_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    private IdentitySslUtil() {
    }

    public static void addTrustedCertificateThumbprint(String className, HttpsURLConnection httpsUrlConnection, final String certificateThumbprint) {
        SSLSocketFactory sslSocketFactory;
        final ClientLogger logger = new ClientLogger(className);
        if (httpsUrlConnection.getHostnameVerifier() != ALL_HOSTS_ACCEPT_HOSTNAME_VERIFIER) {
            httpsUrlConnection.setHostnameVerifier(ALL_HOSTS_ACCEPT_HOSTNAME_VERIFIER);
        }
        TrustManager[] certificateTrust = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certificates, String authenticationType) throws CertificateException {
                throw logger.logExceptionAsError(new RuntimeException("No client side certificate configured."));
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certificates, String authenticationType) throws CertificateException {
                if (certificates == null || certificates.length == 0) {
                    throw logger.logExceptionAsError(new RuntimeException("Did not receive any certificate from the server."));
                }
                for (X509Certificate x509Certificate : certificates) {
                    String sslCertificateThumbprint = IdentitySslUtil.extractCertificateThumbprint(x509Certificate, logger);
                    if (!certificateThumbprint.equalsIgnoreCase(sslCertificateThumbprint)) continue;
                    return;
                }
                throw logger.logExceptionAsError(new RuntimeException("Thumbprint of certificates receieved did not match the expected thumbprint."));
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, certificateTrust, null);
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw logger.logExceptionAsError(new RuntimeException("Error Creating SSL Context", e));
        }
        if (httpsUrlConnection.getSSLSocketFactory() != sslSocketFactory) {
            httpsUrlConnection.setSSLSocketFactory(sslSocketFactory);
        }
    }

    private static String extractCertificateThumbprint(Certificate certificate, ClientLogger logger) {
        try {
            byte[] encodedCertificate;
            StringBuffer thumbprint = new StringBuffer();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            try {
                encodedCertificate = certificate.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] updatedDigest = messageDigest.digest(encodedCertificate);
            for (int i = 0; i < updatedDigest.length; ++i) {
                int unsignedByte = updatedDigest[i] & 0xFF;
                if (unsignedByte < 16) {
                    thumbprint.append("0");
                }
                thumbprint.append(Integer.toHexString(unsignedByte));
            }
            return thumbprint.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.logExceptionAsError(new RuntimeException(e));
        }
    }
}

