/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class EncryptionKeyWrapMetadata {
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String algorithm;

    public EncryptionKeyWrapMetadata() {
    }

    public EncryptionKeyWrapMetadata(EncryptionKeyWrapMetadata source) {
        this.type = source.type;
        this.name = source.name;
        this.value = source.value;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public EncryptionKeyWrapMetadata(String type, String name, String value) {
        Preconditions.checkNotNull(type, "type is null");
        Preconditions.checkNotNull(value, "value is null");
        Preconditions.checkNotNull(name, "name is null");
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public EncryptionKeyWrapMetadata(String type, String name, String value, String algorithm) {
        Preconditions.checkNotNull(type, "type is null");
        Preconditions.checkNotNull(value, "value is null");
        Preconditions.checkNotNull(name, "name is null");
        Preconditions.checkNotNull(algorithm, "algorithm is null");
        this.type = type;
        this.name = name;
        this.value = value;
        this.algorithm = algorithm;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptionKeyWrapMetadata that = (EncryptionKeyWrapMetadata)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.algorithm, that.algorithm);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.value, this.algorithm);
    }
}

